/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.configurationdata;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.glaremasters.guilds.libs.configme.Comment;
import me.glaremasters.guilds.libs.configme.SettingsHolder;
import me.glaremasters.guilds.libs.configme.configurationdata.CommentsConfiguration;
import me.glaremasters.guilds.libs.configme.configurationdata.ConfigurationData;
import me.glaremasters.guilds.libs.configme.configurationdata.ConfigurationDataImpl;
import me.glaremasters.guilds.libs.configme.configurationdata.PropertyListBuilder;
import me.glaremasters.guilds.libs.configme.exception.ConfigMeException;
import me.glaremasters.guilds.libs.configme.properties.Property;

public class ConfigurationDataBuilder {
    protected PropertyListBuilder propertyListBuilder = new PropertyListBuilder();
    protected CommentsConfiguration commentsConfiguration = new CommentsConfiguration();

    protected ConfigurationDataBuilder() {
    }

    @SafeVarargs
    public static ConfigurationData createConfiguration(Class<? extends SettingsHolder> ... classArray) {
        return ConfigurationDataBuilder.createConfiguration(Arrays.asList(classArray));
    }

    public static ConfigurationData createConfiguration(Iterable<Class<? extends SettingsHolder>> iterable) {
        ConfigurationDataBuilder configurationDataBuilder = new ConfigurationDataBuilder();
        return configurationDataBuilder.collectData(iterable);
    }

    public static ConfigurationData createConfiguration(List<? extends Property<?>> list2) {
        return new ConfigurationDataImpl(list2, Collections.emptyMap());
    }

    public static ConfigurationData createConfiguration(List<? extends Property<?>> list2, CommentsConfiguration commentsConfiguration) {
        return new ConfigurationDataImpl(list2, commentsConfiguration.getAllComments());
    }

    protected ConfigurationData collectData(Iterable<Class<? extends SettingsHolder>> iterable) {
        for (Class<? extends SettingsHolder> clazz : iterable) {
            this.collectProperties(clazz);
            this.collectSectionComments(clazz);
        }
        return new ConfigurationDataImpl(this.propertyListBuilder.create(), this.commentsConfiguration.getAllComments());
    }

    protected void collectProperties(Class<?> clazz) {
        this.findFieldsToProcess(clazz).forEach(field -> {
            Property<?> property = this.getPropertyField((Field)field);
            if (property != null) {
                this.propertyListBuilder.add(property);
                this.setCommentForPropertyField((Field)field, property.getPath());
            }
        });
    }

    protected void setCommentForPropertyField(Field field, String string) {
        Comment comment = field.getAnnotation(Comment.class);
        if (comment != null) {
            this.commentsConfiguration.setComment(string, comment.value());
        }
    }

    @Nullable
    protected Property<?> getPropertyField(Field field) {
        if (Property.class.isAssignableFrom(field.getType()) && Modifier.isStatic(field.getModifiers())) {
            try {
                return (Property)field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ConfigMeException("Could not fetch field '" + field.getName() + "' from class '" + field.getDeclaringClass().getSimpleName() + "'. Is it maybe not public?", illegalAccessException);
            }
        }
        return null;
    }

    protected void collectSectionComments(Class<? extends SettingsHolder> clazz) {
        SettingsHolder settingsHolder = this.createSettingsHolderInstance(clazz);
        settingsHolder.registerComments(this.commentsConfiguration);
    }

    protected <T extends SettingsHolder> T createSettingsHolderInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)((SettingsHolder)constructor.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ConfigMeException("Expected no-args constructor to be available for " + clazz, noSuchMethodException);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            throw new ConfigMeException("Could not create instance of " + clazz, reflectiveOperationException);
        }
    }

    protected Stream<Field> findFieldsToProcess(Class<?> clazz) {
        if (Object.class.equals(clazz.getSuperclass())) {
            return Arrays.stream(clazz.getDeclaredFields());
        }
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            arrayList.add(clazz2);
        }
        Collections.reverse(arrayList);
        return arrayList.stream().map(Class::getDeclaredFields).flatMap(Arrays::stream);
    }
}

