/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.configurationdata;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.glaremasters.guilds.libs.configme.SettingsHolder;
import me.glaremasters.guilds.libs.configme.configurationdata.ConfigurationData;
import me.glaremasters.guilds.libs.configme.exception.ConfigMeException;
import me.glaremasters.guilds.libs.configme.properties.Property;
import me.glaremasters.guilds.libs.configme.properties.convertresult.PropertyValue;
import me.glaremasters.guilds.libs.configme.resource.PropertyReader;

public class ConfigurationDataImpl
implements ConfigurationData {
    private final List<Property<?>> properties;
    private final Map<String, List<String>> allComments;
    private final Map<String, Object> values;
    private boolean allPropertiesValidInResource;

    protected ConfigurationDataImpl(List<? extends Property<?>> list2, Map<String, List<String>> map) {
        this.properties = Collections.unmodifiableList(list2);
        this.allComments = Collections.unmodifiableMap(map);
        this.values = new HashMap<String, Object>();
    }

    @Override
    public List<Property<?>> getProperties() {
        return this.properties;
    }

    @Override
    public List<String> getCommentsForSection(String string) {
        return this.allComments.getOrDefault(string, Collections.emptyList());
    }

    @Override
    public Map<String, List<String>> getAllComments() {
        return this.allComments;
    }

    @Override
    public <T> T getValue(Property<T> property) {
        Object object = this.values.get(property.getPath());
        if (object == null) {
            throw new ConfigMeException(String.format("No value exists for property with path '%s'. This may happen if the property belongs to a %s class which was not passed to the settings manager.", property.getPath(), SettingsHolder.class.getSimpleName()));
        }
        return (T)object;
    }

    @Override
    public <T> void setValue(Property<T> property, T t) {
        if (!property.isValidValue(t)) {
            throw new ConfigMeException("Invalid value for property '" + property + "': " + t);
        }
        this.values.put(property.getPath(), t);
    }

    @Override
    public void initializeValues(PropertyReader propertyReader) {
        this.values.clear();
        this.allPropertiesValidInResource = this.getProperties().stream().map(property -> this.setValueForProperty((Property)property, propertyReader)).reduce(true, Boolean::logicalAnd);
    }

    protected <T> boolean setValueForProperty(Property<T> property, PropertyReader propertyReader) {
        PropertyValue<T> propertyValue = property.determineValue(propertyReader);
        this.setValue(property, propertyValue.getValue());
        return propertyValue.isValidInResource();
    }

    @Override
    public boolean areAllValuesValidInResource() {
        return this.allPropertiesValidInResource;
    }

    protected Map<String, Object> getValues() {
        return this.values;
    }
}

