/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.configurationdata;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.glaremasters.guilds.libs.configme.exception.ConfigMeException;
import me.glaremasters.guilds.libs.configme.properties.Property;

public class PropertyListBuilder {
    private Map<String, Object> rootEntries = new LinkedHashMap<String, Object>();

    public void add(Property<?> property) {
        String[] stringArray = property.getPath().split("\\.");
        Map<String, Object> map = this.rootEntries;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            map = PropertyListBuilder.getChildMap(map, stringArray[i]);
        }
        String string = stringArray[stringArray.length - 1];
        if (map.containsKey(string)) {
            throw new ConfigMeException("Path at '" + property.getPath() + "' already exists");
        }
        map.put(string, property);
    }

    public List<Property<?>> create() {
        ArrayList arrayList = new ArrayList();
        PropertyListBuilder.collectEntries(this.rootEntries, arrayList);
        return arrayList;
    }

    protected final Map<String, Object> getRootEntries() {
        return this.rootEntries;
    }

    private static Map<String, Object> getChildMap(Map<String, Object> map, String string) {
        Object object = map.get(string);
        if (object instanceof Map) {
            return PropertyListBuilder.asTypedMap(object);
        }
        if (object == null) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            map.put(string, linkedHashMap);
            return linkedHashMap;
        }
        if (object instanceof Property) {
            throw new ConfigMeException("Unexpected entry found at path '" + string + "'");
        }
        throw new ConfigMeException("Value of unknown type found at '" + string + "': " + object);
    }

    private static void collectEntries(Map<String, Object> map, List<Property<?>> list2) {
        for (Object object : map.values()) {
            if (object instanceof Map) {
                PropertyListBuilder.collectEntries(PropertyListBuilder.asTypedMap(object), list2);
                continue;
            }
            if (!(object instanceof Property)) continue;
            list2.add((Property)object);
        }
    }

    private static Map<String, Object> asTypedMap(Object object) {
        return (Map)object;
    }
}

