/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.properties;

import java.util.Collection;
import java.util.Objects;
import java.util.function.IntFunction;
import me.glaremasters.guilds.libs.configme.properties.BaseProperty;
import me.glaremasters.guilds.libs.configme.properties.convertresult.ConvertErrorRecorder;
import me.glaremasters.guilds.libs.configme.properties.types.PropertyType;
import me.glaremasters.guilds.libs.configme.resource.PropertyReader;

public class ArrayProperty<T>
extends BaseProperty<T[]> {
    private final PropertyType<T> type;
    private final IntFunction<T[]> arrayProducer;

    public ArrayProperty(String string, T[] TArray, PropertyType<T> propertyType, IntFunction<T[]> intFunction) {
        super(string, TArray);
        Objects.requireNonNull(propertyType, "type");
        Objects.requireNonNull(intFunction, "arrayProducer");
        this.type = propertyType;
        this.arrayProducer = intFunction;
    }

    @Override
    protected T[] getFromReader(PropertyReader propertyReader, ConvertErrorRecorder convertErrorRecorder) {
        Object object2 = propertyReader.getObject(this.getPath());
        if (object2 instanceof Collection) {
            Collection collection = (Collection)object2;
            return collection.stream().map(object -> this.type.convert(object, convertErrorRecorder)).filter(Objects::nonNull).toArray(this.arrayProducer);
        }
        return null;
    }

    @Override
    public Object toExportValue(T[] TArray) {
        Object[] objectArray = new Object[TArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.type.toExportValue(TArray[i]);
        }
        return objectArray;
    }
}

