/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.properties;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import me.glaremasters.guilds.libs.configme.properties.BeanProperty;
import me.glaremasters.guilds.libs.configme.properties.BooleanProperty;
import me.glaremasters.guilds.libs.configme.properties.DoubleProperty;
import me.glaremasters.guilds.libs.configme.properties.EnumProperty;
import me.glaremasters.guilds.libs.configme.properties.IntegerProperty;
import me.glaremasters.guilds.libs.configme.properties.LowercaseStringSetProperty;
import me.glaremasters.guilds.libs.configme.properties.OptionalProperty;
import me.glaremasters.guilds.libs.configme.properties.Property;
import me.glaremasters.guilds.libs.configme.properties.PropertyBuilder;
import me.glaremasters.guilds.libs.configme.properties.RegexProperty;
import me.glaremasters.guilds.libs.configme.properties.StringListProperty;
import me.glaremasters.guilds.libs.configme.properties.StringProperty;
import me.glaremasters.guilds.libs.configme.properties.StringSetProperty;
import me.glaremasters.guilds.libs.configme.properties.inlinearray.InlineArrayConverter;
import me.glaremasters.guilds.libs.configme.properties.types.PropertyType;

public class PropertyInitializer {
    protected PropertyInitializer() {
    }

    public static Property<Boolean> newProperty(String string, boolean bl) {
        return new BooleanProperty(string, bl);
    }

    public static Property<Integer> newProperty(String string, int n) {
        return new IntegerProperty(string, n);
    }

    public static Property<Double> newProperty(String string, double d) {
        return new DoubleProperty(string, d);
    }

    public static Property<String> newProperty(String string, String string2) {
        return new StringProperty(string, string2);
    }

    public static <E extends Enum<E>> Property<E> newProperty(Class<E> clazz, String string, E e) {
        return new EnumProperty<E>(clazz, string, e);
    }

    public static RegexProperty newRegexProperty(String string, String string2) {
        return new RegexProperty(string, string2);
    }

    public static RegexProperty newRegexProperty(String string, Pattern pattern) {
        return new RegexProperty(string, pattern);
    }

    public static Property<List<String>> newListProperty(String string, String ... stringArray) {
        return new StringListProperty(string, stringArray);
    }

    public static Property<List<String>> newListProperty(String string, List<String> list2) {
        return new StringListProperty(string, list2);
    }

    public static Property<Set<String>> newSetProperty(String string, String ... stringArray) {
        return new StringSetProperty(string, stringArray);
    }

    public static Property<Set<String>> newSetProperty(String string, Set<String> set) {
        return new StringSetProperty(string, set);
    }

    public static Property<Set<String>> newLowercaseStringSetProperty(String string, String ... stringArray) {
        return new LowercaseStringSetProperty(string, stringArray);
    }

    public static Property<Set<String>> newLowercaseStringSetProperty(String string, Collection<String> collection) {
        return new LowercaseStringSetProperty(string, collection);
    }

    public static <B> Property<B> newBeanProperty(Class<B> clazz, String string, B b) {
        return new BeanProperty<B>(clazz, string, b);
    }

    public static <T> PropertyBuilder.TypeBasedPropertyBuilder<T> typeBasedProperty(PropertyType<T> propertyType) {
        return new PropertyBuilder.TypeBasedPropertyBuilder<T>(propertyType);
    }

    public static <T> PropertyBuilder.ListPropertyBuilder<T> listProperty(PropertyType<T> propertyType) {
        return new PropertyBuilder.ListPropertyBuilder<T>(propertyType);
    }

    public static <T> PropertyBuilder.SetPropertyBuilder<T> setProperty(PropertyType<T> propertyType) {
        return new PropertyBuilder.SetPropertyBuilder<T>(propertyType);
    }

    public static <T> PropertyBuilder.MapPropertyBuilder<T> mapProperty(PropertyType<T> propertyType) {
        return new PropertyBuilder.MapPropertyBuilder<T>(propertyType);
    }

    public static <T> PropertyBuilder.ArrayPropertyBuilder<T> arrayProperty(PropertyType<T> propertyType, IntFunction<T[]> intFunction) {
        return new PropertyBuilder.ArrayPropertyBuilder<T>(propertyType, intFunction);
    }

    public static <T> PropertyBuilder.InlineArrayPropertyBuilder<T> inlineArrayProperty(InlineArrayConverter<T> inlineArrayConverter) {
        return new PropertyBuilder.InlineArrayPropertyBuilder<T>(inlineArrayConverter);
    }

    public static Property<Optional<Boolean>> optionalBooleanProperty(String string) {
        return new OptionalProperty<Boolean>(new BooleanProperty(string, false));
    }

    public static Property<Optional<Integer>> optionalIntegerProperty(String string) {
        return new OptionalProperty<Integer>(new IntegerProperty(string, 0));
    }

    public static Property<Optional<String>> optionalStringProperty(String string) {
        return new OptionalProperty<String>(new StringProperty(string, ""));
    }

    public static <E extends Enum<E>> Property<Optional<E>> optionalEnumProperty(Class<E> clazz, String string) {
        return new OptionalProperty<Enum>(new EnumProperty<Enum>(clazz, string, ((Enum[])clazz.getEnumConstants())[0]));
    }
}

