/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.resource;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.glaremasters.guilds.libs.configme.configurationdata.ConfigurationData;
import me.glaremasters.guilds.libs.configme.exception.ConfigMeException;
import me.glaremasters.guilds.libs.configme.properties.Property;
import me.glaremasters.guilds.libs.configme.resource.PropertyPathTraverser;
import me.glaremasters.guilds.libs.configme.resource.PropertyReader;
import me.glaremasters.guilds.libs.configme.resource.PropertyResource;
import me.glaremasters.guilds.libs.configme.resource.YamlFileReader;
import me.glaremasters.guilds.libs.configme.resource.YamlFileResourceOptions;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlFileResource
implements PropertyResource {
    private final Path path;
    private final YamlFileResourceOptions options;
    private final String indentationSpace;
    private Yaml yamlObject;

    public YamlFileResource(Path path) {
        this(path, YamlFileResourceOptions.builder().build());
    }

    public YamlFileResource(Path path, YamlFileResourceOptions yamlFileResourceOptions) {
        this.path = path;
        this.options = yamlFileResourceOptions;
        this.indentationSpace = yamlFileResourceOptions.getIndentation();
    }

    @Deprecated
    public YamlFileResource(File file) {
        this(file.toPath());
    }

    @Override
    public PropertyReader createReader() {
        return new YamlFileReader(this.path, this.options.getCharset(), this.options.splitDotPaths());
    }

    @Override
    public void exportProperties(ConfigurationData configurationData) {
        try (OutputStream outputStream = Files.newOutputStream(this.path, new OpenOption[0]);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.options.getCharset());){
            PropertyPathTraverser propertyPathTraverser = new PropertyPathTraverser(configurationData);
            for (Property<?> property : configurationData.getProperties()) {
                Object object = this.getExportValue(property, configurationData);
                this.exportValue(outputStreamWriter, propertyPathTraverser, Arrays.asList(property.getPath().split("\\.")), object);
            }
            outputStreamWriter.append("\n");
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw new ConfigMeException("Could not save config to '" + this.path + "'", iOException);
        }
        finally {
            this.onWriteComplete();
        }
    }

    protected final Path getPath() {
        return this.path;
    }

    @Deprecated
    protected final File getFile() {
        return this.path.toFile();
    }

    protected void exportValue(Writer writer, PropertyPathTraverser propertyPathTraverser, List<String> list2, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Map && !((Map)object).isEmpty()) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                List<String> list3 = this.combinePathElementsAndMapEntryKey(list2, (String)entry.getKey());
                this.exportValue(writer, propertyPathTraverser, list3, entry.getValue());
            }
        } else {
            List<PropertyPathTraverser.PathElement> list4 = propertyPathTraverser.getPathElements(list2);
            boolean bl = list4.size() == 1 && "".equals(list4.get(0).getName());
            for (PropertyPathTraverser.PathElement pathElement : list4) {
                this.writeIndentingBetweenLines(writer, pathElement);
                this.writeComments(writer, pathElement.getIndentationLevel(), pathElement);
                writer.append(this.getNewLineIfNotFirstElement(pathElement));
                if (bl) continue;
                writer.append(this.indent(pathElement.getIndentationLevel())).append(this.escapePathElementIfNeeded(pathElement.getName())).append(":");
            }
            if (!bl) {
                writer.append(" ");
            }
            writer.append(this.toYamlIndented(object, list4.get(list4.size() - 1).getIndentationLevel()));
        }
    }

    protected void writeComments(Writer writer, int n, PropertyPathTraverser.PathElement pathElement) {
        if (pathElement.getComments().isEmpty()) {
            return;
        }
        String string = pathElement.isFirstElement() ? "" : "\n";
        String string2 = this.indent(n) + "# ";
        for (String string3 : pathElement.getComments()) {
            writer.append(string);
            string = "\n";
            if ("\n".equals(string3)) continue;
            writer.append(string2).append(string3);
        }
    }

    protected List<String> combinePathElementsAndMapEntryKey(List<String> list2, String string) {
        Stream stream = list2.size() == 1 && "".equals(list2.get(0)) ? Stream.empty() : list2.stream();
        Stream<String> stream2 = this.options.splitDotPaths() ? Arrays.stream(string.split("\\.")) : Stream.of(string);
        return Stream.concat(stream, stream2).collect(Collectors.toList());
    }

    private void writeIndentingBetweenLines(Writer writer, PropertyPathTraverser.PathElement pathElement) {
        int n = this.options.getNumberOfEmptyLinesBefore(pathElement);
        for (int i = 0; i < n; ++i) {
            writer.append("\n");
        }
    }

    private String getNewLineIfNotFirstElement(PropertyPathTraverser.PathElement pathElement) {
        return pathElement.isFirstElement() && pathElement.getComments().isEmpty() ? "" : "\n";
    }

    protected String toYamlIndented(@Nullable Object object, int n) {
        String string = this.toYaml(object);
        CharSequence[] charSequenceArray = string.split("\\n");
        return String.join((CharSequence)("\n" + this.indent(n)), charSequenceArray);
    }

    protected String toYaml(@Nullable Object object) {
        if (object instanceof String) {
            return this.getYamlObject().dump(object);
        }
        if (object instanceof Collection) {
            List<?> list2 = YamlFileResource.collectionToList((Collection)object);
            return list2.isEmpty() ? "[]" : "\n" + this.getYamlObject().dump(list2);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return objectArray.length == 0 ? "[]" : "\n" + this.getYamlObject().dump(objectArray);
        }
        return this.getYamlObject().dump(object);
    }

    protected String indent(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return this.indentationSpace;
            }
            case 2: {
                return this.indentationSpace + this.indentationSpace;
            }
            case 3: {
                return this.indentationSpace + this.indentationSpace + this.indentationSpace;
            }
            case 4: {
                return this.indentationSpace + this.indentationSpace + this.indentationSpace + this.indentationSpace;
            }
            case 5: {
                return this.indentationSpace + this.indentationSpace + this.indentationSpace + this.indentationSpace + this.indentationSpace;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(n * this.indentationSpace.length());
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.indentationSpace);
        }
        return stringBuilder.toString();
    }

    protected String escapePathElementIfNeeded(String string) {
        return this.getYamlObject().dump(string).trim();
    }

    protected void onWriteComplete() {
        this.yamlObject = null;
    }

    protected Yaml getYamlObject() {
        if (this.yamlObject == null) {
            this.yamlObject = this.createNewYaml();
        }
        return this.yamlObject;
    }

    protected Yaml createNewYaml() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setAllowUnicode(true);
        return new Yaml(dumperOptions);
    }

    protected final YamlFileResourceOptions getOptions() {
        return this.options;
    }

    private <T> Object getExportValue(Property<T> property, ConfigurationData configurationData) {
        return property.toExportValue(configurationData.getValue(property));
    }

    private static List<?> collectionToList(Collection<?> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList(collection);
    }
}

