/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.glaremasters.guilds.libs.configme.exception.ConfigMeException;

public final class Utils {
    private Utils() {
    }

    public static void createFileIfNotExists(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new ConfigMeException("Expected file but '" + path + "' is not a file");
            }
        } else {
            Path path2 = path.getParent();
            if (!Files.exists(path2, new LinkOption[0]) || !Files.isDirectory(path2, new LinkOption[0])) {
                try {
                    Files.createDirectories(path2, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    throw new ConfigMeException("Failed to create parent folders for '" + path + "'", iOException);
                }
            }
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new ConfigMeException("Failed to create file '" + path + "'", iOException);
            }
        }
    }
}

