/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import me.glaremasters.guilds.libs.jdbi.v3.core.ConnectionException;
import me.glaremasters.guilds.libs.jdbi.v3.core.ConnectionFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.ConstantHandleSupplier;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.HandleCallback;
import me.glaremasters.guilds.libs.jdbi.v3.core.HandleConsumer;
import me.glaremasters.guilds.libs.jdbi.v3.core.LazyHandleSupplier;
import me.glaremasters.guilds.libs.jdbi.v3.core.OnDemandExtensions;
import me.glaremasters.guilds.libs.jdbi.v3.core.SingleConnectionFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.Configurable;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.ExtensionCallback;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.ExtensionConsumer;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.Extensions;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.HandleSupplier;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.NoSuchExtensionException;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.Unchecked;
import me.glaremasters.guilds.libs.jdbi.v3.core.spi.JdbiPlugin;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.DefaultStatementBuilder;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementBuilder;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementBuilderFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.transaction.LocalTransactionHandler;
import me.glaremasters.guilds.libs.jdbi.v3.core.transaction.TransactionHandler;
import me.glaremasters.guilds.libs.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jdbi
implements Configurable<Jdbi> {
    private static final Logger LOG = LoggerFactory.getLogger(Jdbi.class);
    private final ConfigRegistry config = new ConfigRegistry();
    private final ConnectionFactory connectionFactory;
    private final AtomicReference<TransactionHandler> transactionhandler = new AtomicReference<LocalTransactionHandler>(new LocalTransactionHandler());
    private final AtomicReference<StatementBuilderFactory> statementBuilderFactory = new AtomicReference<StatementBuilderFactory>(DefaultStatementBuilder.FACTORY);
    private final CopyOnWriteArrayList<JdbiPlugin> plugins = new CopyOnWriteArrayList();
    private final ThreadLocal<HandleSupplier> threadHandleSupplier = new ThreadLocal();

    private Jdbi(ConnectionFactory connectionFactory) {
        Objects.requireNonNull(connectionFactory, "null connectionFactory");
        this.connectionFactory = connectionFactory;
    }

    public static Jdbi create(Connection connection) {
        return Jdbi.create(new SingleConnectionFactory(connection));
    }

    public static Jdbi create(DataSource dataSource) {
        return Jdbi.create(dataSource::getConnection);
    }

    public static Jdbi create(ConnectionFactory connectionFactory) {
        return new Jdbi(connectionFactory);
    }

    public static Jdbi create(String string) {
        Objects.requireNonNull(string, "null url");
        return Jdbi.create(() -> DriverManager.getConnection(string));
    }

    public static Jdbi create(String string, Properties properties) {
        Objects.requireNonNull(string, "null url");
        Objects.requireNonNull(properties, "null properties");
        return Jdbi.create(() -> DriverManager.getConnection(string, properties));
    }

    public static Jdbi create(String string, String string2, String string3) {
        Objects.requireNonNull(string, "null url");
        Objects.requireNonNull(string2, "null username");
        Objects.requireNonNull(string3, "null password");
        return Jdbi.create(() -> DriverManager.getConnection(string, string2, string3));
    }

    public static Handle open(DataSource dataSource) {
        return Jdbi.create(dataSource).open();
    }

    public static Handle open(ConnectionFactory connectionFactory) {
        return Jdbi.create(connectionFactory).open();
    }

    public static Handle open(Connection connection) {
        Objects.requireNonNull(connection, "null connection");
        return Jdbi.create(() -> connection).open();
    }

    public static Handle open(String string) {
        return Jdbi.create(string).open();
    }

    public static Handle open(String string, String string2, String string3) {
        return Jdbi.create(string, string2, string3).open();
    }

    public static Handle open(String string, Properties properties) {
        return Jdbi.create(string, properties).open();
    }

    public Jdbi installPlugins() {
        ServiceLoader.load(JdbiPlugin.class).forEach(this::installPlugin);
        LOG.debug("Automatically installed plugins {}", (Object)this.plugins);
        return this;
    }

    public Jdbi installPlugin(JdbiPlugin jdbiPlugin) {
        Unchecked.consumer(jdbiPlugin::customizeJdbi).accept(this);
        this.plugins.add(jdbiPlugin);
        return this;
    }

    public Jdbi setStatementBuilderFactory(StatementBuilderFactory statementBuilderFactory) {
        this.statementBuilderFactory.set(statementBuilderFactory);
        return this;
    }

    public StatementBuilderFactory getStatementBuilderFactory() {
        return this.statementBuilderFactory.get();
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.config;
    }

    public Jdbi setTransactionHandler(TransactionHandler transactionHandler) {
        Objects.requireNonNull(transactionHandler, "null transaction handler");
        this.transactionhandler.set(transactionHandler);
        return this;
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionhandler.get();
    }

    /*
     * WARNING - void declaration
     */
    public Handle open() {
        try {
            void var7_8;
            long l = System.nanoTime();
            Connection connection = this.connectionFactory.openConnection();
            long l2 = System.nanoTime();
            for (JdbiPlugin object2 : this.plugins) {
                connection = object2.customizeConnection(connection);
            }
            StatementBuilder statementBuilder = this.statementBuilderFactory.get().createStatementBuilder(connection);
            Handle handle = new Handle(this.config.createCopy(), this.connectionFactory::closeConnection, this.transactionhandler.get(), statementBuilder, connection);
            for (JdbiPlugin jdbiPlugin : this.plugins) {
                Handle handle2 = jdbiPlugin.customizeHandle((Handle)var7_8);
            }
            LOG.trace("Jdbi [{}] obtain handle [{}] in {}ms", this, var7_8, TimeUnit.MILLISECONDS.convert(l2 - l, TimeUnit.NANOSECONDS));
            return var7_8;
        }
        catch (SQLException sQLException) {
            throw new ConnectionException(sQLException);
        }
    }

    /*
     * Loose catch block
     */
    public <R, X extends Exception> R withHandle(HandleCallback<R, X> handleCallback) {
        if (this.threadHandleSupplier.get() != null) {
            return handleCallback.withHandle(this.threadHandleSupplier.get().getHandle());
        }
        try {
            R r;
            try (Handle handle = this.open();){
                this.threadHandleSupplier.set(new ConstantHandleSupplier(handle));
                r = handleCallback.withHandle(handle);
            }
            return r;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.threadHandleSupplier.remove();
        }
    }

    public <X extends Exception> void useHandle(HandleConsumer<X> handleConsumer) {
        this.withHandle(handle -> {
            handleConsumer.useHandle(handle);
            return null;
        });
    }

    public <R, X extends Exception> R inTransaction(HandleCallback<R, X> handleCallback) {
        return (R)this.withHandle(handle -> handle.inTransaction(handleCallback));
    }

    public <X extends Exception> void useTransaction(HandleConsumer<X> handleConsumer) {
        this.useHandle(handle -> handle.useTransaction(handleConsumer));
    }

    public <R, X extends Exception> R inTransaction(TransactionIsolationLevel transactionIsolationLevel, HandleCallback<R, X> handleCallback) {
        return (R)this.withHandle(handle -> handle.inTransaction(transactionIsolationLevel, handleCallback));
    }

    public <X extends Exception> void useTransaction(TransactionIsolationLevel transactionIsolationLevel, HandleConsumer<X> handleConsumer) {
        this.useHandle(handle -> handle.useTransaction(transactionIsolationLevel, handleConsumer));
    }

    /*
     * Loose catch block
     */
    public <R, E, X extends Exception> R withExtension(Class<E> clazz, ExtensionCallback<R, E, X> extensionCallback) {
        if (this.threadHandleSupplier.get() != null) {
            return this.callWithExtension(clazz, extensionCallback, this.threadHandleSupplier.get());
        }
        try {
            R r;
            try (LazyHandleSupplier lazyHandleSupplier = new LazyHandleSupplier(this, this.config);){
                this.threadHandleSupplier.set(lazyHandleSupplier);
                r = this.callWithExtension(clazz, extensionCallback, lazyHandleSupplier);
            }
            return r;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.threadHandleSupplier.remove();
        }
    }

    private <R, E, X extends Exception> R callWithExtension(Class<E> clazz, ExtensionCallback<R, E, X> extensionCallback, HandleSupplier handleSupplier) {
        E e = this.getConfig(Extensions.class).findFor(clazz, handleSupplier).orElseThrow(() -> new NoSuchExtensionException("Extension not found: " + clazz));
        return extensionCallback.withExtension(e);
    }

    public <E, X extends Exception> void useExtension(Class<E> clazz, ExtensionConsumer<E, X> extensionConsumer) {
        this.withExtension(clazz, object -> {
            extensionConsumer.useExtension(object);
            return null;
        });
    }

    public <E> E onDemand(Class<E> clazz) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("On-demand extensions are only supported for interfaces.");
        }
        if (!this.getConfig(Extensions.class).hasExtensionFor(clazz)) {
            throw new NoSuchExtensionException("Extension not found: " + clazz);
        }
        return OnDemandExtensions.create(this, clazz);
    }
}

