/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.ArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.BoxedArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.EnumArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.EssentialsArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.InternetArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.JavaTimeArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.JavaTimeZoneIdArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NVarcharArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NullArgument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.OptionalArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.PrimitivesArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.QualifiedArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.SqlArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.SqlTimeArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.UntypedNullArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.JdbiOptionals;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.meta.Beta;

public class Arguments
implements JdbiConfig<Arguments> {
    private final List<QualifiedArgumentFactory> factories = new CopyOnWriteArrayList<QualifiedArgumentFactory>();
    private ConfigRegistry registry;
    private Argument untypedNullArgument = new NullArgument(1111);

    public Arguments() {
        this.register(new UntypedNullArgumentFactory());
        this.register(new PrimitivesArgumentFactory());
        this.register(new BoxedArgumentFactory());
        this.register(new SqlArgumentFactory());
        this.register(new InternetArgumentFactory());
        this.register(new SqlTimeArgumentFactory());
        this.register(new JavaTimeArgumentFactory());
        this.register(new SqlArrayArgumentFactory());
        this.register(new EssentialsArgumentFactory());
        this.register(new JavaTimeZoneIdArgumentFactory());
        this.register(new NVarcharArgumentFactory());
        this.register(new EnumArgumentFactory());
        this.register(new OptionalArgumentFactory());
    }

    @Override
    public void setRegistry(ConfigRegistry configRegistry) {
        this.registry = configRegistry;
    }

    private Arguments(Arguments arguments) {
        this.factories.addAll(arguments.factories);
        this.untypedNullArgument = arguments.untypedNullArgument;
    }

    public Arguments register(ArgumentFactory argumentFactory) {
        return this.register(QualifiedArgumentFactory.adapt(argumentFactory));
    }

    private Arguments register(QualifiedArgumentFactory qualifiedArgumentFactory) {
        this.factories.add(0, qualifiedArgumentFactory);
        return this;
    }

    public Optional<Argument> findFor(Type type, Object object) {
        return this.findFor(QualifiedType.of(type), object);
    }

    @Beta
    public Optional<Argument> findFor(QualifiedType<?> qualifiedType, Object object) {
        return this.factories.stream().flatMap(qualifiedArgumentFactory -> JdbiOptionals.stream(qualifiedArgumentFactory.build(qualifiedType, object, this.registry))).findFirst();
    }

    public void setUntypedNullArgument(Argument argument) {
        if (argument == null) {
            throw new IllegalArgumentException("the Argument itself may not be null");
        }
        this.untypedNullArgument = argument;
    }

    public Argument getUntypedNullArgument() {
        return this.untypedNullArgument;
    }

    @Override
    public Arguments createCopy() {
        return new Arguments(this);
    }
}

