/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.ArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NullArgument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal.StatementBinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal.strategies.LoggableBinderArgument;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;

abstract class DelegatingArgumentFactory
implements ArgumentFactory {
    private final Map<Class<?>, Function<?, Argument>> builders = new IdentityHashMap();

    DelegatingArgumentFactory() {
    }

    @Override
    public Optional<Argument> build(Type type, Object object, ConfigRegistry configRegistry) {
        Class<?> clazz = GenericTypes.getErasedType(type);
        if (object != null && clazz == Object.class) {
            clazz = object.getClass();
        }
        Function<?, Argument> function2 = this.builders.get(clazz);
        return Optional.ofNullable(function2).map(function -> (Argument)function.apply(object));
    }

    <T> void register(Class<T> clazz, int n, StatementBinder<T> statementBinder) {
        this.builders.put(clazz, object -> object == null ? new NullArgument(n) : new LoggableBinderArgument<Object>(object, statementBinder));
    }
}

