/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.argument;

import java.io.InputStream;
import java.sql.PreparedStatement;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

public class InputStreamArgument
implements Argument {
    private final InputStream value;
    private final int length;
    private final boolean ascii;

    public InputStreamArgument(InputStream inputStream, int n, boolean bl) {
        this.value = inputStream;
        this.length = n;
        this.ascii = bl;
    }

    @Override
    public void apply(int n, PreparedStatement preparedStatement, StatementContext statementContext) {
        if (this.ascii) {
            if (this.value == null) {
                preparedStatement.setNull(n, -1);
            } else {
                preparedStatement.setAsciiStream(n, this.value, this.length);
            }
        } else if (this.value == null) {
            preparedStatement.setNull(n, -4);
        } else {
            preparedStatement.setBinaryStream(n, this.value, this.length);
        }
    }

    public String toString() {
        return "<stream object cannot be read for toString() calls>";
    }
}

