/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.argument;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NamedArgumentFinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal.ObjectPropertyNamedArgumentFinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal.TypedValue;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCache;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCaches;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.Qualifiers;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToCreateStatementException;

public class ObjectFieldArguments
extends ObjectPropertyNamedArgumentFinder {
    private static final JdbiCache<Class<?>, Map<String, Field>> FIELD_CACHE = JdbiCaches.declare(clazz -> Stream.of(clazz.getFields()).collect(Collectors.toMap(Field::getName, Function.identity())));
    private final Class<?> beanClass;

    public ObjectFieldArguments(String string, Object object) {
        super(string, object);
        this.beanClass = object.getClass();
    }

    @Override
    protected Optional<TypedValue> getValue(String string, StatementContext statementContext) {
        Field field = FIELD_CACHE.get(this.beanClass, statementContext).get(string);
        if (field == null) {
            return Optional.empty();
        }
        try {
            QualifiedType<?> qualifiedType = QualifiedType.of(field.getGenericType()).withAnnotations(statementContext.getConfig(Qualifiers.class).findFor(field));
            Object object = field.get(this.obj);
            return Optional.of(new TypedValue(qualifiedType, object));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnableToCreateStatementException(String.format("Access exception getting field for bean property [%s] on [%s]", string, this.obj), illegalAccessException, statementContext);
        }
    }

    @Override
    protected NamedArgumentFinder getNestedArgumentFinder(Object object) {
        return new ObjectFieldArguments(null, object);
    }

    public String toString() {
        return "{lazy bean field arguments \"" + this.obj + "\"";
    }
}

