/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Arguments;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NamedArgumentFinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal.TypedValue;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToCreateStatementException;

public abstract class ObjectPropertyNamedArgumentFinder
implements NamedArgumentFinder {
    final String prefix;
    protected final Object obj;
    private final Map<String, Optional<NamedArgumentFinder>> childArgumentFinders = new ConcurrentHashMap<String, Optional<NamedArgumentFinder>>();

    protected ObjectPropertyNamedArgumentFinder(String string, Object object) {
        this.prefix = string == null || string.isEmpty() ? "" : string + ".";
        this.obj = object;
    }

    @Override
    public final Optional<Argument> find(String string, StatementContext statementContext) {
        if (string.startsWith(this.prefix)) {
            String string2 = string.substring(this.prefix.length());
            int n = string2.indexOf(46);
            if (n != -1) {
                String string4 = string2.substring(0, n);
                String string5 = string2.substring(n + 1);
                return this.childArgumentFinders.computeIfAbsent(string4.endsWith("?") ? string4.substring(0, string4.length() - 1) : string4, string3 -> this.getValue((String)string3, statementContext).map(typedValue -> this.getValueNested((TypedValue)typedValue, string4, string5))).flatMap(namedArgumentFinder -> namedArgumentFinder.find(string5, statementContext));
            }
            return this.getValue(string2, statementContext).map(typedValue -> statementContext.findArgumentFor(typedValue.type, typedValue.value).orElseThrow(() -> new UnableToCreateStatementException(String.format("No argument factory registered for type [%s] for element [%s] on [%s]", typedValue.type, string, this.obj), statementContext)));
        }
        return Optional.empty();
    }

    private NamedArgumentFinder getValueNested(TypedValue typedValue, String string2, String string3) {
        if (Objects.nonNull(typedValue.value)) {
            return this.getNestedArgumentFinder(typedValue.value);
        }
        if (string2.endsWith("?")) {
            return (string, statementContext) -> Optional.of(statementContext.getConfig(Arguments.class).getUntypedNullArgument());
        }
        throw new IllegalArgumentException(String.format("Trying to bind nested argument [%s], but found nullpointer at [%s], may mark it as an optional with [%s]", string3, string2, string2 + '?'));
    }

    protected abstract Optional<TypedValue> getValue(String var1, StatementContext var2);

    protected abstract NamedArgumentFinder getNestedArgumentFinder(Object var1);
}

