/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.array;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

class ArrayColumnMapper
implements ColumnMapper<Object> {
    private static final CopyOnWriteArraySet<Integer> UNSUPPORTED_TYPES = new CopyOnWriteArraySet();
    private final ColumnMapper<?> elementMapper;
    private final Class<?> componentType;

    ArrayColumnMapper(ColumnMapper<?> columnMapper, Class<?> clazz) {
        this.elementMapper = columnMapper;
        this.componentType = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object map(ResultSet resultSet, int n, StatementContext statementContext) {
        java.sql.Array array = resultSet.getArray(n);
        if (array == null) {
            return null;
        }
        try {
            Object object = this.buildArray(array, statementContext);
            return object;
        }
        finally {
            array.free();
        }
    }

    private Object buildArray(java.sql.Array array, StatementContext statementContext) {
        if (!UNSUPPORTED_TYPES.contains(array.getBaseType())) {
            try {
                Object object = array.getArray();
                if (this.componentType.equals(object.getClass().getComponentType())) {
                    return object;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        UNSUPPORTED_TYPES.add(array.getBaseType());
        return this.buildFromResultSet(array, statementContext);
    }

    private Object buildFromResultSet(java.sql.Array array, StatementContext statementContext) {
        ArrayList arrayList = new ArrayList();
        try (Object object = array.getResultSet();){
            while (object.next()) {
                arrayList.add(this.elementMapper.map((ResultSet)object, 2, statementContext));
            }
        }
        object = Array.newInstance(this.componentType, arrayList.size());
        if (this.componentType.isPrimitive()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Array.set(object, i, arrayList.get(i));
            }
            return object;
        }
        return arrayList.toArray((Object[])object);
    }
}

