/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.array;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.InferredSqlArrayTypeFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayArgumentStrategy;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayType;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayTypeFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;
import me.glaremasters.guilds.libs.jdbi.v3.core.enums.internal.EnumSqlArrayTypeFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.JdbiOptionals;

public class SqlArrayTypes
implements JdbiConfig<SqlArrayTypes> {
    private final List<SqlArrayTypeFactory> factories = new CopyOnWriteArrayList<SqlArrayTypeFactory>();
    private SqlArrayArgumentStrategy argumentStrategy;
    private ConfigRegistry registry;

    public SqlArrayTypes() {
        this.argumentStrategy = SqlArrayArgumentStrategy.SQL_ARRAY;
        this.register(new EnumSqlArrayTypeFactory());
    }

    private SqlArrayTypes(SqlArrayTypes sqlArrayTypes) {
        this.factories.addAll(sqlArrayTypes.factories);
        this.argumentStrategy = sqlArrayTypes.argumentStrategy;
    }

    public SqlArrayArgumentStrategy getArgumentStrategy() {
        return this.argumentStrategy;
    }

    public SqlArrayTypes setArgumentStrategy(SqlArrayArgumentStrategy sqlArrayArgumentStrategy) {
        this.argumentStrategy = sqlArrayArgumentStrategy;
        return this;
    }

    public SqlArrayTypes register(Class<?> clazz, String string) {
        return this.register(SqlArrayTypeFactory.of(clazz, string, Function.identity()));
    }

    public SqlArrayTypes register(SqlArrayType<?> sqlArrayType) {
        return this.register(new InferredSqlArrayTypeFactory(sqlArrayType));
    }

    public SqlArrayTypes register(SqlArrayTypeFactory sqlArrayTypeFactory) {
        this.factories.add(0, sqlArrayTypeFactory);
        return this;
    }

    public Optional<SqlArrayType<?>> findFor(Type type) {
        return this.factories.stream().flatMap(sqlArrayTypeFactory -> JdbiOptionals.stream(sqlArrayTypeFactory.build(type, this.registry))).findFirst();
    }

    @Override
    public void setRegistry(ConfigRegistry configRegistry) {
        this.registry = configRegistry;
    }

    @Override
    public SqlArrayTypes createCopy() {
        return new SqlArrayTypes(this);
    }
}

