/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.collector;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.stream.Collector;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.ArrayBuilder;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.CollectorFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;

class ArrayCollectorFactory
implements CollectorFactory {
    ArrayCollectorFactory() {
    }

    @Override
    public boolean accepts(Type type) {
        return GenericTypes.getErasedType(type).isArray();
    }

    @Override
    public Optional<Type> elementType(Type type) {
        return Optional.ofNullable(GenericTypes.getErasedType(type).getComponentType());
    }

    @Override
    public Collector<?, ?, ?> build(Type type) {
        Class<?> clazz = GenericTypes.getErasedType(type).getComponentType();
        return Collector.of(() -> new ArrayBuilder(clazz), ArrayBuilder::add, (arrayBuilder, arrayBuilder2) -> {
            arrayBuilder.list.addAll(arrayBuilder2.list);
            return arrayBuilder;
        }, ArrayBuilder::build, new Collector.Characteristics[0]);
    }
}

