/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.collector;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.CollectorFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;

class EnumSetCollectorFactory
implements CollectorFactory {
    EnumSetCollectorFactory() {
    }

    @Override
    public boolean accepts(Type type) {
        return EnumSet.class.isAssignableFrom(GenericTypes.getErasedType(type)) && type instanceof ParameterizedType;
    }

    @Override
    public Optional<Type> elementType(Type type) {
        return GenericTypes.findGenericParameter(type, EnumSet.class);
    }

    @Override
    public Collector<?, ?, ?> build(Type type) {
        return this.build0(type);
    }

    private <E extends Enum<E>> Collector<E, ?, ?> build0(Type type) {
        Class clazz = GenericTypes.findGenericParameter(type, EnumSet.class).map(GenericTypes::getErasedType).orElseThrow(() -> new IllegalStateException("Cannot determine EnumSet element type"));
        return Collector.of(() -> EnumSet.noneOf(clazz), AbstractCollection::add, (enumSet, enumSet2) -> {
            enumSet.addAll(enumSet2);
            return enumSet;
        }, Function.identity(), new Collector.Characteristics[0]);
    }
}

