/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.collector;

import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collector;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.UtilityClassException;

public class MapCollectors {
    private MapCollectors() {
        throw new UtilityClassException();
    }

    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<K, V>, ?, M> toMap(Supplier<M> supplier) {
        return Collector.of(supplier, MapCollectors::putEntry, MapCollectors::combine, new Collector.Characteristics[0]);
    }

    private static <K, V, M extends Map<K, V>> void putEntry(M m, Map.Entry<K, V> entry) {
        MapCollectors.putEntry(m, entry.getKey(), entry.getValue());
    }

    private static <K, V, M extends Map<K, V>> void putEntry(M m, K k, V v) {
        V v2 = m.put(k, v);
        if (v2 != null) {
            throw new IllegalStateException(String.format("Multiple values for Map key '%s': ['%s','%s',...]", k, v2, v));
        }
    }

    private static <K, V, M extends Map<K, V>> M combine(M m, M m2) {
        m2.forEach((object, object2) -> MapCollectors.putEntry(m, object, object2));
        return m;
    }
}

