/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.config;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCaches;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;

public class ConfigRegistry {
    private final Object createLock = new Object();
    private final Map<Class<? extends JdbiConfig<?>>, JdbiConfig<?>> configs = new ConcurrentHashMap();

    public ConfigRegistry() {
        this.configs.put(JdbiCaches.class, new JdbiCaches());
    }

    private ConfigRegistry(ConfigRegistry configRegistry) {
        configRegistry.configs.forEach((clazz, jdbiConfig) -> {
            Object This = jdbiConfig.createCopy();
            This.setRegistry(this);
            this.configs.put((Class<JdbiConfig<?>>)clazz, (JdbiConfig<?>)This);
        });
    }

    public <C extends JdbiConfig<C>> C get(Class<C> clazz) {
        JdbiConfig<?> jdbiConfig = this.configs.get(clazz);
        if (jdbiConfig != null) {
            return (C)((JdbiConfig)clazz.cast(jdbiConfig));
        }
        Object object = this.createLock;
        synchronized (object) {
            try {
                JdbiConfig jdbiConfig2 = (JdbiConfig)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                jdbiConfig2.setRegistry(this);
                return (C)Optional.ofNullable(clazz.cast(this.configs.putIfAbsent(clazz, jdbiConfig2))).orElse(jdbiConfig2);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new IllegalStateException("Unable to instantiate config class " + clazz + ". Is there a public no-arg constructor?", reflectiveOperationException);
            }
        }
    }

    public ConfigRegistry createCopy() {
        return new ConfigRegistry(this);
    }
}

