/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.enums.internal;

import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.enums.EnumStrategy;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.EnumStrategies;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.EnumMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.QualifiedColumnMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;

public class EnumMapperFactory
implements QualifiedColumnMapperFactory {
    @Override
    public Optional<ColumnMapper<?>> build(QualifiedType<?> qualifiedType, ConfigRegistry configRegistry) {
        return Optional.of(qualifiedType.getType()).map(GenericTypes::getErasedType).filter(Class::isEnum).map(clazz -> EnumMapperFactory.makeEnumArgument(qualifiedType, clazz, configRegistry));
    }

    private static <E extends Enum<E>> ColumnMapper<?> makeEnumArgument(QualifiedType<E> qualifiedType, Class<E> clazz, ConfigRegistry configRegistry) {
        boolean bl = EnumStrategy.BY_NAME == configRegistry.get(EnumStrategies.class).findStrategy(qualifiedType);
        return bl ? EnumMapper.byName(clazz) : EnumMapper.byOrdinal(clazz);
    }
}

