/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.generic;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.UtilityClassException;

public class GenericTypes {
    private static final TypeVariable<Class<Map>> KEY;
    private static final TypeVariable<Class<Map>> VALUE;

    private GenericTypes() {
        throw new UtilityClassException();
    }

    public static Class<?> getErasedType(Type type) {
        return GenericTypeReflector.erase(type);
    }

    public static Optional<Type> findGenericParameter(Type type, Class<?> clazz) {
        return GenericTypes.findGenericParameter(type, clazz, 0);
    }

    public static Optional<Type> findGenericParameter(Type type, Class<?> clazz, int n) {
        return Optional.ofNullable(GenericTypeReflector.getTypeParameter(type, clazz.getTypeParameters()[n]));
    }

    public static Type resolveType(Type type, Type type2) {
        return GenericTypeReflector.resolveType(type, type2);
    }

    public static boolean isArray(Type type) {
        return type instanceof Class && ((Class)type).isArray();
    }

    public static Type resolveMapEntryType(Type type) {
        Type type2 = GenericTypes.resolveType(KEY, type);
        Type type3 = GenericTypes.resolveType(VALUE, type);
        return GenericTypes.resolveMapEntryType(type2, type3);
    }

    public static Type resolveMapEntryType(Type type, Type type2) {
        return TypeFactory.parameterizedClass(Map.Entry.class, type, type2);
    }

    public static Type parameterizeClass(Class<?> clazz, Type ... typeArray) {
        return TypeFactory.parameterizedClass(clazz, typeArray);
    }

    static {
        TypeVariable<Class<T>>[] typeVariableArray = Map.class.getTypeParameters();
        KEY = typeVariableArray[0];
        VALUE = typeVariableArray[1];
    }
}

