/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.internal;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.Unchecked;

public class AnnotationFactory {
    private AnnotationFactory() {
    }

    public static <T extends Annotation> T create(Class<T> clazz) {
        return AnnotationFactory.create(clazz, Collections.emptyMap());
    }

    public static <T extends Annotation> T create(Class<T> clazz, Map<String, ?> map) {
        Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.getDefaultValue() == null).filter(method -> !map.containsKey(method.getName())).findAny().ifPresent(method -> {
            throw new IllegalArgumentException(String.format("Cannot synthesize annotation @%s from %s.class because it has attribute " + method.getName() + " without a default or specified value", clazz.getSimpleName(), clazz.getSimpleName()));
        });
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class[] classArray = new Class[]{clazz};
        InvocationHandler invocationHandler = AnnotationFactory.getInvocationHandler(clazz, map);
        Annotation annotation = (Annotation)Proxy.newProxyInstance(classLoader, classArray, invocationHandler);
        return (T)annotation;
    }

    private static <T extends Annotation> InvocationHandler getInvocationHandler(Class<T> clazz, Map<String, ?> map) {
        Function<Method, Object> function = method -> Optional.ofNullable(map.get(method.getName())).orElseGet(method::getDefaultValue);
        int n = Arrays.stream(clazz.getDeclaredMethods()).mapToInt(method -> AnnotationFactory.memberHash(method.getName(), function.apply((Method)method))).sum();
        String string = "@" + clazz.getName() + "(" + map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(", ")) + ")";
        return (object, method, objectArray) -> {
            String string2 = method.getName();
            if ("annotationType".equals(string2) && method.getParameterCount() == 0) {
                return clazz;
            }
            if ("equals".equals(string2) && method.getParameterCount() == 1 && Object.class.equals(method.getParameterTypes()[0])) {
                Annotation annotation = (Annotation)objectArray[0];
                return clazz.equals(annotation.annotationType()) && AnnotationFactory.valuesEqual(clazz, object, annotation);
            }
            if ("hashCode".equals(string2) && method.getParameterCount() == 0) {
                return n;
            }
            if ("toString".equals(string2) && method.getParameterCount() == 0) {
                return string;
            }
            if (method.getDeclaringClass() == clazz) {
                return function.apply(method);
            }
            throw new IllegalStateException("Unknown method " + method + " for annotation type " + clazz);
        };
    }

    private static int memberHash(String string, Object object) {
        return 127 * string.hashCode() ^ AnnotationFactory.valueHash(object);
    }

    private static int valueHash(Object object) {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return object.hashCode();
        }
        return Unchecked.supplier(() -> MethodHandles.publicLookup().findStatic(Arrays.class, "hashCode", MethodType.methodType(Integer.TYPE, clazz)).invoke(object)).get();
    }

    private static <A extends Annotation> boolean valuesEqual(Class<A> clazz, Object object2, Object object3) {
        for (Method method : clazz.getDeclaredMethods()) {
            Function<Object, Object> function = Unchecked.function(object -> method.invoke(object, new Object[0]));
            Object object4 = function.apply(object2);
            Object object5 = function.apply(object3);
            if (object4 != null && object5 != null && object4.getClass().isArray() && object4.getClass().equals(object5.getClass()) && Boolean.FALSE.equals(Unchecked.supplier(() -> MethodHandles.publicLookup().findStatic(Arrays.class, "equals", MethodType.methodType(Boolean.TYPE, object4.getClass(), object5.getClass())).invoke(object2, object3)).get())) {
                return false;
            }
            if (Objects.equals(object4, object5)) continue;
            return false;
        }
        return true;
    }
}

