/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.UtilityClassException;

public class IterableLike {
    private IterableLike() {
        throw new UtilityClassException();
    }

    public static boolean isIterable(Object object) {
        return object instanceof Iterator || object instanceof Iterable || object.getClass().isArray();
    }

    public static Iterator<Object> of(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("can't iterate null");
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Iterable) {
            return ((Iterable)object).iterator();
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException(IterableLike.getTypeWarning(clazz));
        }
        if (clazz.getComponentType().isPrimitive()) {
            return new PrimitiveArrayIterator(object);
        }
        return Arrays.asList((Object[])object).iterator();
    }

    public static Optional<Type> elementTypeOf(Object object) {
        return IterableLike.elementTypeOf(object.getClass());
    }

    public static Optional<Type> elementTypeOf(Type type) {
        Class<?> clazz = GenericTypes.getErasedType(type);
        if (clazz.isArray()) {
            return Optional.of(clazz.getComponentType());
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return GenericTypes.findGenericParameter(type, Iterable.class);
        }
        if (Iterator.class.isAssignableFrom(clazz)) {
            return GenericTypes.findGenericParameter(type, Iterator.class);
        }
        return Optional.empty();
    }

    public static Stream<Object> stream(Object object) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(IterableLike.of(object), 16), false);
    }

    public static Iterable<Object> iterable(Object object) {
        return () -> IterableLike.of(object);
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("cannot determine emptiness of null");
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Iterable) {
            return !((Iterable)object).iterator().hasNext();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        throw new IllegalArgumentException(IterableLike.getTypeWarning(object.getClass()));
    }

    public static List<Object> toList(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IterableLike.of(object).forEachRemaining(arrayList::add);
        return arrayList;
    }

    private static String getTypeWarning(Class<?> clazz) {
        return "argument must be one of the following: Iterable, or an array/varargs (primitive or complex type); was " + clazz.getName() + " instead";
    }

    static class PrimitiveArrayIterator
    implements Iterator<Object> {
        private int index = 0;
        private final int size;
        private final Object arr;

        PrimitiveArrayIterator(Object object) {
            this.size = Array.getLength(object);
            this.arr = object;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public Object next() {
            if (this.hasNext()) {
                return Array.get(this.arr, this.index++);
            }
            throw new NoSuchElementException("only " + this.size + " elements available");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

