/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions;

import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.UtilityClassException;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.CheckedBiConsumer;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.CheckedBiFunction;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.CheckedCallable;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.CheckedConsumer;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.CheckedFunction;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.CheckedSupplier;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.Sneaky;

public class Unchecked {
    private Unchecked() {
        throw new UtilityClassException();
    }

    public static <T> Consumer<T> consumer(CheckedConsumer<T> checkedConsumer) {
        return object -> {
            try {
                checkedConsumer.accept(object);
            }
            catch (Throwable throwable) {
                throw Sneaky.throwAnyway(throwable);
            }
        };
    }

    public static Runnable runnable(CheckedRunnable checkedRunnable) {
        return () -> {
            try {
                checkedRunnable.run();
            }
            catch (Throwable throwable) {
                throw Sneaky.throwAnyway(throwable);
            }
        };
    }

    public static <T> SneakyCallable<T> callable(CheckedCallable<T> checkedCallable) {
        return () -> {
            try {
                return checkedCallable.call();
            }
            catch (Throwable throwable) {
                throw Sneaky.throwAnyway(throwable);
            }
        };
    }

    public static <T> Supplier<T> supplier(CheckedSupplier<T> checkedSupplier) {
        return () -> {
            try {
                return checkedSupplier.get();
            }
            catch (Throwable throwable) {
                throw Sneaky.throwAnyway(throwable);
            }
        };
    }

    public static <X, T> Function<X, T> function(CheckedFunction<X, T> checkedFunction) {
        return object -> {
            try {
                return checkedFunction.apply(object);
            }
            catch (Throwable throwable) {
                throw Sneaky.throwAnyway(throwable);
            }
        };
    }

    public static <X, Y, T> BiFunction<X, Y, T> biFunction(CheckedBiFunction<X, Y, T> checkedBiFunction) {
        return (object, object2) -> {
            try {
                return checkedBiFunction.apply(object, object2);
            }
            catch (Throwable throwable) {
                throw Sneaky.throwAnyway(throwable);
            }
        };
    }

    public static <X, Y> BiConsumer<X, Y> biConsumer(CheckedBiConsumer<X, Y> checkedBiConsumer) {
        return (object, object2) -> {
            try {
                checkedBiConsumer.accept(object, object2);
            }
            catch (Throwable throwable) {
                throw Sneaky.throwAnyway(throwable);
            }
        };
    }

    public static interface CheckedRunnable {
        public void run() throws Exception;
    }

    public static interface SneakyCallable<T>
    extends Callable<T> {
        @Override
        public T call();
    }
}

