/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.GetterMapper;

class BoxedMapperFactory
implements ColumnMapperFactory {
    private final Map<Class<?>, ColumnMapper<?>> mappers = new IdentityHashMap();

    BoxedMapperFactory() {
        this.mappers.put(Boolean.class, new GetterMapper<Boolean>(ResultSet::getBoolean));
        this.mappers.put(Byte.class, new GetterMapper<Byte>(ResultSet::getByte));
        this.mappers.put(Character.class, new GetterMapper<Character>(BoxedMapperFactory::getCharacter));
        this.mappers.put(Short.class, new GetterMapper<Short>(ResultSet::getShort));
        this.mappers.put(Integer.class, new GetterMapper<Integer>(ResultSet::getInt));
        this.mappers.put(Long.class, new GetterMapper<Long>(ResultSet::getLong));
        this.mappers.put(Float.class, new GetterMapper<Float>(ResultSet::getFloat));
        this.mappers.put(Double.class, new GetterMapper<Double>(ResultSet::getDouble));
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry configRegistry) {
        Class<?> clazz = GenericTypes.getErasedType(type);
        return Optional.ofNullable(this.mappers.get(clazz));
    }

    private static Character getCharacter(ResultSet resultSet, int n) {
        String string = resultSet.getString(n);
        return string == null || string.isEmpty() ? null : Character.valueOf(string.charAt(0));
    }
}

