/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;
import me.glaremasters.guilds.libs.jdbi.v3.core.enums.internal.EnumMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericType;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.JdbiOptionals;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.BoxedMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.EssentialsMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.InferredColumnMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.InternetMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.JavaTimeMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.NVarcharMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.OptionalMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.PrimitiveMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.QualifiedColumnMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.SqlTimeMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.meta.Beta;

public class ColumnMappers
implements JdbiConfig<ColumnMappers> {
    private final List<QualifiedColumnMapperFactory> factories = new CopyOnWriteArrayList<QualifiedColumnMapperFactory>();
    private final ConcurrentHashMap<QualifiedType<?>, ColumnMapper<?>> cache = new ConcurrentHashMap();
    private ConfigRegistry registry;

    public ColumnMappers() {
        this.register(new SqlArrayMapperFactory());
        this.register(new JavaTimeMapperFactory());
        this.register(new SqlTimeMapperFactory());
        this.register(new InternetMapperFactory());
        this.register(new EssentialsMapperFactory());
        this.register(new BoxedMapperFactory());
        this.register(new PrimitiveMapperFactory());
        this.register(new OptionalMapperFactory());
        this.register(new EnumMapperFactory());
        this.register(new NVarcharMapper());
    }

    @Override
    public void setRegistry(ConfigRegistry configRegistry) {
        this.registry = configRegistry;
    }

    private ColumnMappers(ColumnMappers columnMappers) {
        this.factories.addAll(columnMappers.factories);
        this.cache.putAll(columnMappers.cache);
    }

    public ColumnMappers register(ColumnMapper<?> columnMapper) {
        return this.register(new InferredColumnMapperFactory(columnMapper));
    }

    public <T> ColumnMappers register(GenericType<T> genericType, ColumnMapper<T> columnMapper) {
        return this.register(ColumnMapperFactory.of(genericType.getType(), columnMapper));
    }

    public ColumnMappers register(Type type, ColumnMapper<?> columnMapper) {
        return this.register(ColumnMapperFactory.of(type, columnMapper));
    }

    @Beta
    public <T> ColumnMappers register(QualifiedType<T> qualifiedType, ColumnMapper<T> columnMapper) {
        return this.register(QualifiedColumnMapperFactory.of(qualifiedType, columnMapper));
    }

    public ColumnMappers register(ColumnMapperFactory columnMapperFactory) {
        return this.register(QualifiedColumnMapperFactory.adapt(columnMapperFactory));
    }

    private ColumnMappers register(QualifiedColumnMapperFactory qualifiedColumnMapperFactory) {
        this.factories.add(0, qualifiedColumnMapperFactory);
        this.cache.clear();
        return this;
    }

    public <T> Optional<ColumnMapper<T>> findFor(Class<T> clazz) {
        ColumnMapper columnMapper = this.findFor((Type)clazz).orElse(null);
        return Optional.ofNullable(columnMapper);
    }

    public <T> Optional<ColumnMapper<T>> findFor(GenericType<T> genericType) {
        ColumnMapper columnMapper = this.findFor(genericType.getType()).orElse(null);
        return Optional.ofNullable(columnMapper);
    }

    public Optional<ColumnMapper<?>> findFor(Type type) {
        return this.findFor(QualifiedType.of(type)).map(columnMapper -> columnMapper);
    }

    @Beta
    public <T> Optional<ColumnMapper<T>> findFor(QualifiedType<T> qualifiedType) {
        ColumnMapper<?> columnMapper2 = this.cache.get(qualifiedType);
        if (columnMapper2 != null) {
            return Optional.of(columnMapper2);
        }
        Optional<ColumnMapper<ColumnMapper>> optional = this.factories.stream().flatMap(qualifiedColumnMapperFactory -> JdbiOptionals.stream(qualifiedColumnMapperFactory.build(qualifiedType, this.registry))).findFirst().map(columnMapper -> columnMapper);
        optional.ifPresent(columnMapper -> this.cache.put(qualifiedType, (ColumnMapper<?>)columnMapper));
        return optional;
    }

    @Override
    public ColumnMappers createCopy() {
        return new ColumnMappers(this);
    }
}

