/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericType;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMappers;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.MapMappers;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.meta.Beta;

@Beta
public class GenericMapMapperFactory
implements RowMapperFactory {
    @Override
    public Optional<RowMapper<?>> build(Type type2, ConfigRegistry configRegistry) {
        return Optional.of(type2).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).filter(parameterizedType -> Map.class.equals((Object)parameterizedType.getRawType())).filter(parameterizedType -> String.class.equals(GenericTypes.findGenericParameter(parameterizedType, Map.class, 0).orElse(null))).flatMap(parameterizedType -> GenericTypes.findGenericParameter(parameterizedType, Map.class, 1)).filter(type -> !Object.class.equals(type)).flatMap(configRegistry.get(ColumnMappers.class)::findFor).map(columnMapper -> new GenericMapMapper((ColumnMapper)columnMapper));
    }

    @Beta
    public static <T> RowMapper<Map<String, T>> getMapperForValueType(Class<T> clazz, ConfigRegistry configRegistry) {
        return configRegistry.get(ColumnMappers.class).findFor(clazz).map(columnMapper -> new GenericMapMapper((ColumnMapper)columnMapper)).orElseThrow(() -> new RuntimeException("no column mapper found for type " + clazz));
    }

    @Beta
    public static <T> RowMapper<Map<String, T>> getMapperForValueType(GenericType<T> genericType, ConfigRegistry configRegistry) {
        return configRegistry.get(ColumnMappers.class).findFor(genericType).map(columnMapper -> new GenericMapMapper((ColumnMapper)columnMapper)).orElseThrow(() -> new RuntimeException("no column mapper found for type " + genericType));
    }

    private static class GenericMapMapper<T>
    implements RowMapper<Map<String, T>> {
        private final ColumnMapper<T> mapper;

        private GenericMapMapper(ColumnMapper<T> columnMapper) {
            this.mapper = columnMapper;
        }

        @Override
        public Map<String, T> map(ResultSet resultSet, StatementContext statementContext) {
            return this.specialize(resultSet, statementContext).map(resultSet, statementContext);
        }

        @Override
        public RowMapper<Map<String, T>> specialize(ResultSet resultSet2, StatementContext statementContext) {
            List<String> list2 = GenericMapMapper.getMapKeys(resultSet2.getMetaData(), statementContext.getConfig(MapMappers.class).getCaseChange());
            return (resultSet, statementContext2) -> {
                HashMap hashMap = new HashMap();
                for (int i = 0; i < list2.size(); ++i) {
                    T t = this.mapper.map(resultSet, i + 1, statementContext);
                    hashMap.put(list2.get(i), t);
                }
                return hashMap;
            };
        }

        private static List<String> getMapKeys(ResultSetMetaData resultSetMetaData, UnaryOperator<String> unaryOperator) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String string = resultSetMetaData.getColumnName(i + 1);
                String string2 = resultSetMetaData.getColumnLabel(i + 1);
                String string3 = string2 == null ? string : string2;
                String string4 = (String)unaryOperator.apply(string3);
                boolean bl = linkedHashSet.add(string4);
                if (bl) continue;
                throw new RuntimeException(String.format("map key \"%s\" (from column \"%s\") appears twice in this resultset!", string4, string3));
            }
            return new ArrayList<String>(linkedHashSet);
        }
    }
}

