/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.internal;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCache;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCaches;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.Qualifiers;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToCreateStatementException;

public class BeanPropertiesFactory {
    private static final JdbiCache<Type, Map<String, BeanPojoProperties.BeanPojoProperty<?>>> PROPERTY_CACHE = JdbiCaches.declare(BeanPropertiesFactory::getProperties0);
    private static final String TYPE_NOT_INSTANTIABLE = "A bean, %s, was mapped which was not instantiable";
    private static final String MISSING_SETTER = "No appropriate method to write property %s";
    private static final String SETTER_NOT_ACCESSIBLE = "Unable to access setter for property, %s";
    private static final String INVOCATION_TARGET_EXCEPTION = "Invocation target exception trying to invoker setter for the %s property";
    private static final String REFLECTION_ILLEGAL_ARGUMENT_EXCEPTION = "Write method of %s for property %s is not compatible with the value passed";

    private BeanPropertiesFactory() {
    }

    public static PojoProperties<?> propertiesFor(Type type, ConfigRegistry configRegistry) {
        return new BeanPojoProperties(type, configRegistry);
    }

    private static boolean shouldSeeProperty(PropertyDescriptor propertyDescriptor) {
        Method method = propertyDescriptor.getReadMethod();
        return method == null || method.getDeclaringClass() != Object.class;
    }

    private static Map<String, BeanPojoProperties.BeanPojoProperty<?>> getProperties0(Type type) {
        try {
            return Arrays.stream(Introspector.getBeanInfo(GenericTypes.getErasedType(type)).getPropertyDescriptors()).filter(BeanPropertiesFactory::shouldSeeProperty).map(BeanPojoProperties.BeanPojoProperty::new).collect(Collectors.toMap(PojoProperties.PojoProperty::getName, Function.identity()));
        }
        catch (IntrospectionException introspectionException) {
            throw new IllegalArgumentException("Failed to inspect bean " + type, introspectionException);
        }
    }

    static class BeanPojoProperties<T>
    extends PojoProperties<T> {
        private final ConfigRegistry config;

        BeanPojoProperties(Type type, ConfigRegistry configRegistry) {
            super(type);
            this.config = configRegistry;
        }

        @Override
        public Map<String, BeanPojoProperty<T>> getProperties() {
            return (Map)PROPERTY_CACHE.get(this.getType(), this.config);
        }

        @Override
        public PojoProperties.PojoBuilder<T> create() {
            Object obj;
            Class<?> clazz = GenericTypes.getErasedType(this.getType());
            try {
                obj = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(String.format(BeanPropertiesFactory.TYPE_NOT_INSTANTIABLE, clazz.getName()), exception);
            }
            return new PojoProperties.PojoBuilder<T>(){

                @Override
                public void set(String string, Object object) {
                    BeanPojoProperty beanPojoProperty = this.getProperties().get(string);
                    try {
                        Method method = beanPojoProperty.descriptor.getWriteMethod();
                        if (method == null) {
                            throw new IllegalArgumentException(String.format(BeanPropertiesFactory.MISSING_SETTER, string));
                        }
                        method.invoke(obj, object);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IllegalArgumentException(String.format(BeanPropertiesFactory.SETTER_NOT_ACCESSIBLE, string), illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new IllegalArgumentException(String.format(BeanPropertiesFactory.INVOCATION_TARGET_EXCEPTION, string), invocationTargetException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalArgumentException(String.format(BeanPropertiesFactory.REFLECTION_ILLEGAL_ARGUMENT_EXCEPTION, beanPojoProperty.getQualifiedType(), beanPojoProperty.getName()), illegalArgumentException);
                    }
                }

                @Override
                public T build() {
                    return obj;
                }
            };
        }

        static class BeanPojoProperty<T>
        implements PojoProperties.PojoProperty<T> {
            final PropertyDescriptor descriptor;

            BeanPojoProperty(PropertyDescriptor propertyDescriptor) {
                this.descriptor = propertyDescriptor;
            }

            @Override
            public String getName() {
                return this.descriptor.getName();
            }

            @Override
            public QualifiedType<?> getQualifiedType() {
                Parameter parameter = Optional.ofNullable(this.descriptor.getWriteMethod()).map(method -> method.getParameterCount() > 0 ? method.getParameters()[0] : null).orElse(null);
                return QualifiedType.of(Optional.ofNullable(this.descriptor.getReadMethod()).map(Method::getGenericReturnType).orElseGet(() -> this.descriptor.getWriteMethod().getGenericParameterTypes()[0])).withAnnotations(new Qualifiers().findFor(this.descriptor.getReadMethod(), this.descriptor.getWriteMethod(), parameter));
            }

            @Override
            public <A extends Annotation> Optional<A> getAnnotation(Class<A> clazz) {
                return Stream.of(this.descriptor.getReadMethod(), this.descriptor.getWriteMethod()).filter(Objects::nonNull).map(method -> method.getAnnotation(clazz)).filter(Objects::nonNull).findFirst();
            }

            @Override
            public Object get(T t) {
                Method method = this.descriptor.getReadMethod();
                if (method == null) {
                    throw new UnableToCreateStatementException(String.format("No getter method found for bean property [%s] on [%s]", this.getName(), t));
                }
                try {
                    return method.invoke(t, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new UnableToCreateStatementException(String.format("Access exception invoking method [%s] on [%s]", method.getName(), t), illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new UnableToCreateStatementException(String.format("Invocation target exception invoking method [%s] on [%s]", method.getName(), t), invocationTargetException);
                }
            }
        }
    }
}

