/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.Objects;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultIterator;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultSetException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

class ResultSetResultIterator<T>
implements ResultIterator<T> {
    private final ResultSet results;
    private final RowMapper<T> mapper;
    private final StatementContext context;
    private volatile boolean alreadyAdvanced = false;
    private volatile boolean hasNext = false;
    private volatile boolean closed = false;

    ResultSetResultIterator(ResultSet resultSet, RowMapper<T> rowMapper, StatementContext statementContext) {
        this.results = Objects.requireNonNull(resultSet);
        this.mapper = rowMapper.specialize(resultSet, statementContext);
        this.context = statementContext;
        this.context.addCleanable(resultSet::close);
    }

    @Override
    public void close() {
        this.closed = true;
        this.context.close();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        if (this.alreadyAdvanced) {
            return this.hasNext;
        }
        this.hasNext = this.safeNext();
        if (this.hasNext) {
            this.alreadyAdvanced = true;
        } else {
            this.close();
        }
        return this.hasNext;
    }

    @Override
    public T next() {
        if (this.closed) {
            throw new IllegalStateException("iterator is closed");
        }
        if (!this.hasNext()) {
            this.close();
            throw new NoSuchElementException("No element to advance to");
        }
        try {
            T t = this.mapper.map(this.results, this.context);
            return t;
        }
        catch (SQLException sQLException) {
            throw new ResultSetException("Error thrown mapping result set into return type", sQLException, this.context);
        }
        finally {
            this.alreadyAdvanced = this.safeNext();
            if (!this.alreadyAdvanced) {
                this.close();
            }
        }
    }

    @Override
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Deleting from a result set iterator is not yet supported");
    }

    private boolean safeNext() {
        try {
            return this.results.next();
        }
        catch (SQLException sQLException) {
            throw new ResultSetException("Unable to advance result set", sQLException, this.context);
        }
    }
}

