/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.result.internal;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.MappingException;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.NoSuchMapperException;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.RowView;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

public class RowViewImpl
extends RowView {
    private final StatementContext ctx;
    private final ResultSet rs;
    private final Map<Type, RowMapper<?>> rowMappers = new ConcurrentHashMap();
    private final Map<QualifiedType<?>, ColumnMapper<?>> columnMappers = new ConcurrentHashMap();

    public RowViewImpl(ResultSet resultSet, StatementContext statementContext) {
        this.rs = resultSet;
        this.ctx = statementContext;
    }

    @Override
    public Object getRow(Type type) {
        try {
            return this.rowMapperFor(type).map(this.rs, this.ctx);
        }
        catch (SQLException sQLException) {
            throw new MappingException(sQLException);
        }
    }

    private RowMapper<?> rowMapperFor(Type type) {
        if (this.rowMappers.containsKey(type)) {
            return this.rowMappers.get(type);
        }
        RowMapper<?> rowMapper = this.ctx.findRowMapperFor(type).orElseThrow(() -> new NoSuchMapperException("No row mapper registered for " + type)).specialize(this.rs, this.ctx);
        this.rowMappers.put(type, rowMapper);
        return rowMapper;
    }

    @Override
    public <T> T getColumn(int n, QualifiedType<T> qualifiedType) {
        try {
            return (T)this.columnMapperFor(qualifiedType).map(this.rs, n, this.ctx);
        }
        catch (SQLException sQLException) {
            throw new MappingException(sQLException);
        }
    }

    @Override
    public <T> T getColumn(String string, QualifiedType<T> qualifiedType) {
        try {
            return (T)this.columnMapperFor(qualifiedType).map(this.rs, string, this.ctx);
        }
        catch (SQLException sQLException) {
            throw new MappingException(sQLException);
        }
    }

    private ColumnMapper<?> columnMapperFor(QualifiedType<?> qualifiedType2) {
        return this.columnMappers.computeIfAbsent(qualifiedType2, qualifiedType -> this.ctx.findColumnMapperFor(qualifiedType).orElseThrow(() -> new NoSuchMapperException("No column mapper registered for " + qualifiedType)));
    }
}

