/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OutParameters {
    private final Map<Object, Object> map = new HashMap<Object, Object>();

    public <T> T getObject(String string, Class<T> clazz) {
        return clazz.cast(this.getObject(string));
    }

    public Object getObject(String string) {
        return this.map.get(string);
    }

    public Object getObject(int n) {
        return this.map.get(n);
    }

    public <T> T getObject(int n, Class<T> clazz) {
        return clazz.cast(this.getObject(n));
    }

    public String getString(String string) {
        Object object = this.map.get(string);
        if (object == null) {
            if (!this.map.containsKey(string)) {
                throw new IllegalArgumentException(String.format("Parameter %s does not exist", string));
            }
            return null;
        }
        return object.toString();
    }

    public String getString(int n) {
        Object object = this.map.get(n);
        if (object == null) {
            if (!this.map.containsKey(n)) {
                throw new IllegalArgumentException(String.format("Parameter at %d does not exist", n));
            }
            return null;
        }
        return object.toString();
    }

    public byte[] getBytes(String string) {
        Object object = this.map.get(string);
        if (object == null) {
            if (!this.map.containsKey(string)) {
                throw new IllegalArgumentException(String.format("Parameter %s does not exist", string));
            }
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        throw new IllegalArgumentException(String.format("Parameter %s is not byte[] but %s", string, object.getClass()));
    }

    public byte[] getBytes(int n) {
        Object object = this.map.get(n);
        if (object == null) {
            if (!this.map.containsKey(n)) {
                throw new IllegalArgumentException(String.format("Parameter at %d does not exist", n));
            }
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        throw new IllegalArgumentException(String.format("Parameter at %d is not byte[] but %s", n, object.getClass()));
    }

    public Integer getInt(String string) {
        return this.getNumber(string).intValue();
    }

    public Integer getInt(int n) {
        return this.getNumber(n).intValue();
    }

    public Long getLong(String string) {
        return this.getNumber(string).longValue();
    }

    public Long getLong(int n) {
        return this.getNumber(n).longValue();
    }

    public Short getShort(String string) {
        return this.getNumber(string).shortValue();
    }

    public Short getShort(int n) {
        return this.getNumber(n).shortValue();
    }

    public java.sql.Date getDate(String string) {
        Long l = this.getEpoch(string);
        if (l == null) {
            return null;
        }
        return new java.sql.Date(l);
    }

    public java.sql.Date getDate(int n) {
        Long l = this.getEpoch(n);
        if (l == null) {
            return null;
        }
        return new java.sql.Date(l);
    }

    public Timestamp getTimestamp(String string) {
        Long l = this.getEpoch(string);
        if (l == null) {
            return null;
        }
        return new Timestamp(l);
    }

    public Timestamp getTimestamp(int n) {
        Long l = this.getEpoch(n);
        if (l == null) {
            return null;
        }
        return new Timestamp(l);
    }

    public Double getDouble(String string) {
        return this.getNumber(string).doubleValue();
    }

    public Double getDouble(int n) {
        return this.getNumber(n).doubleValue();
    }

    public Float getFloat(String string) {
        return Float.valueOf(this.getNumber(string).floatValue());
    }

    public Float getFloat(int n) {
        return Float.valueOf(this.getNumber(n).floatValue());
    }

    private Number getNumber(String string) {
        Object object = this.map.get(string);
        if (object == null) {
            if (!this.map.containsKey(string)) {
                throw new IllegalArgumentException(String.format("Parameter %s does not exist", string));
            }
            return null;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new IllegalArgumentException(String.format("Parameter %s is not a number but %s", string, object.getClass()));
    }

    private Number getNumber(int n) {
        Object object = this.map.get(n);
        if (object == null) {
            if (!this.map.containsKey(n)) {
                throw new IllegalArgumentException(String.format("Parameter at %d does not exist", n));
            }
            return null;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new IllegalArgumentException(String.format("Parameter at %d is not a number but %s", n, object.getClass()));
    }

    private Long getEpoch(String string) {
        Object object = this.map.get(string);
        if (object == null) {
            if (!this.map.containsKey(string)) {
                throw new IllegalArgumentException(String.format("Parameter %s does not exist", string));
            }
            return null;
        }
        if (object instanceof Date) {
            return ((Date)object).getTime();
        }
        throw new IllegalArgumentException(String.format("Parameter %s is not Date but %s", string, object.getClass()));
    }

    private Long getEpoch(int n) {
        Object object = this.map.get(n);
        if (object == null) {
            if (!this.map.containsKey(n)) {
                throw new IllegalArgumentException(String.format("Parameter at %d does not exist", n));
            }
            return null;
        }
        if (object instanceof Date) {
            return ((Date)object).getTime();
        }
        throw new IllegalArgumentException(String.format("Parameter at %d is not Date but %s", n, object.getClass()));
    }

    Map<Object, Object> getMap() {
        return this.map;
    }
}

