/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Arguments;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.BeanPropertyArguments;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.CharacterStreamArgument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.InputStreamArgument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.MapArguments;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NamedArgumentFinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NullArgument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.ObjectArgument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.ObjectFieldArguments;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.ObjectMethodArguments;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal.PojoPropertyArguments;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericType;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.Mappers;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.NVarchar;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.ArgumentBinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.BaseStatement;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Binding;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Call;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.DefineNamedBindingsStatementCustomizer;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.ParsedSql;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlLoggerUtil;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlStatements;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementCustomizers;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToCreateStatementException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToExecuteStatementException;
import me.glaremasters.guilds.libs.jdbi.v3.meta.Beta;

public abstract class SqlStatement<This extends SqlStatement<This>>
extends BaseStatement<This> {
    private final Handle handle;
    private final String sql;
    PreparedStatement stmt;

    SqlStatement(Handle handle, String string) {
        super(handle);
        this.handle = handle;
        this.sql = string;
        this.getContext().setConnection(handle.getConnection()).setRawSql(string);
    }

    protected Binding getBinding() {
        return this.getContext().getBinding();
    }

    protected String getSql() {
        return this.sql;
    }

    public This setQueryTimeout(int n) {
        return (This)((SqlStatement)this.addCustomizer(StatementCustomizers.statementTimeout(n)));
    }

    public This cleanupHandleCommit() {
        return this.cleanupHandle(Handle::commit);
    }

    public This cleanupHandleRollback() {
        return this.cleanupHandle(Handle::rollback);
    }

    private This cleanupHandle(Consumer<Handle> consumer) {
        this.addCleanable(() -> {
            if (this.handle != null) {
                if (this.handle.isInTransaction()) {
                    consumer.accept(this.handle);
                }
                this.handle.close();
            }
        });
        return (This)((SqlStatement)this.typedThis);
    }

    public This bind(int n, Argument argument) {
        this.getBinding().addPositional(n, argument);
        return (This)this;
    }

    public This bind(String string, Argument argument) {
        this.getBinding().addNamed(string, argument);
        return (This)((SqlStatement)this.typedThis);
    }

    public This bindBean(Object object) {
        return this.bindNamedArgumentFinder(new BeanPropertyArguments(null, object));
    }

    public This bindBean(String string, Object object) {
        return this.bindNamedArgumentFinder(new BeanPropertyArguments(string, object));
    }

    @Beta
    public This bindPojo(Object object) {
        return this.bindPojo(null, object);
    }

    @Beta
    public This bindPojo(String string, Object object) {
        return this.bindNamedArgumentFinder(new PojoPropertyArguments(string, object, this.getConfig()));
    }

    public This bindFields(Object object) {
        return this.bindNamedArgumentFinder(new ObjectFieldArguments(null, object));
    }

    public This bindFields(String string, Object object) {
        return this.bindNamedArgumentFinder(new ObjectFieldArguments(string, object));
    }

    public This bindMethods(Object object) {
        return this.bindNamedArgumentFinder(new ObjectMethodArguments(null, object));
    }

    public This bindMethods(String string, Object object) {
        return this.bindNamedArgumentFinder(new ObjectMethodArguments(string, object));
    }

    public This bindMap(Map<String, ?> map) {
        return (This)(map == null ? (SqlStatement)this.typedThis : this.bindNamedArgumentFinder(new MapArguments(map)));
    }

    public This bindNamedArgumentFinder(NamedArgumentFinder namedArgumentFinder) {
        if (namedArgumentFinder != null) {
            this.getBinding().addNamedArgumentFinder(namedArgumentFinder);
        }
        return (This)((SqlStatement)this.typedThis);
    }

    public final This bind(int n, Character c) {
        return this.bind(n, this.toArgument((Type)((Object)Character.class), (Object)c));
    }

    public final This bind(String string, Character c) {
        return this.bind(string, this.toArgument((Type)((Object)Character.class), (Object)c));
    }

    public final This bind(int n, String string) {
        return this.bind(n, this.toArgument((Type)((Object)String.class), (Object)string));
    }

    public final This bind(String string, String string2) {
        return this.bind(string, this.toArgument((Type)((Object)String.class), (Object)string2));
    }

    @Beta
    public final This bindNVarchar(int n, String string) {
        return this.bind(n, this.toArgument(QualifiedType.of(String.class).with(NVarchar.class), (Object)string));
    }

    @Beta
    public final This bindNVarchar(String string, String string2) {
        return this.bind(string, this.toArgument(QualifiedType.of(String.class).with(NVarchar.class), (Object)string2));
    }

    public final This bind(int n, int n2) {
        return this.bind(n, this.toArgument(Integer.TYPE, (Object)n2));
    }

    public final This bind(int n, Integer n2) {
        return this.bind(n, this.toArgument((Type)((Object)Integer.class), (Object)n2));
    }

    public final This bind(String string, int n) {
        return this.bind(string, this.toArgument(Integer.TYPE, (Object)n));
    }

    public final This bind(String string, Integer n) {
        return this.bind(string, this.toArgument((Type)((Object)Integer.class), (Object)n));
    }

    public final This bind(int n, char c) {
        return this.bind(n, this.toArgument(Character.TYPE, (Object)Character.valueOf(c)));
    }

    public final This bind(String string, char c) {
        return this.bind(string, this.toArgument(Character.TYPE, (Object)Character.valueOf(c)));
    }

    public final This bindASCIIStream(int n, InputStream inputStream, int n2) {
        return this.bind(n, (Argument)new InputStreamArgument(inputStream, n2, true));
    }

    public final This bindASCIIStream(String string, InputStream inputStream, int n) {
        return this.bind(string, (Argument)new InputStreamArgument(inputStream, n, true));
    }

    public final This bind(int n, BigDecimal bigDecimal) {
        return this.bind(n, this.toArgument((Type)((Object)BigDecimal.class), (Object)bigDecimal));
    }

    public final This bind(String string, BigDecimal bigDecimal) {
        return this.bind(string, this.toArgument((Type)((Object)BigDecimal.class), (Object)bigDecimal));
    }

    public final This bindBinaryStream(int n, InputStream inputStream, int n2) {
        return this.bind(n, (Argument)new InputStreamArgument(inputStream, n2, false));
    }

    public final This bindBinaryStream(String string, InputStream inputStream, int n) {
        return this.bind(string, (Argument)new InputStreamArgument(inputStream, n, false));
    }

    public final This bind(int n, Blob blob) {
        return this.bind(n, this.toArgument((Type)((Object)Blob.class), (Object)blob));
    }

    public final This bind(String string, Blob blob) {
        return this.bind(string, this.toArgument((Type)((Object)Blob.class), (Object)blob));
    }

    public final This bind(int n, boolean bl) {
        return this.bind(n, this.toArgument(Boolean.TYPE, (Object)bl));
    }

    public final This bind(int n, Boolean bl) {
        return this.bind(n, this.toArgument((Type)((Object)Boolean.class), (Object)bl));
    }

    public final This bind(String string, boolean bl) {
        return this.bind(string, this.toArgument(Boolean.TYPE, (Object)bl));
    }

    public final This bind(String string, Boolean bl) {
        return this.bind(string, this.toArgument((Type)((Object)Boolean.class), (Object)bl));
    }

    public final This bind(int n, byte by) {
        return this.bind(n, this.toArgument(Byte.TYPE, (Object)by));
    }

    public final This bind(int n, Byte by) {
        return this.bind(n, this.toArgument((Type)((Object)Byte.class), (Object)by));
    }

    public final This bind(String string, byte by) {
        return this.bind(string, this.toArgument(Byte.TYPE, (Object)by));
    }

    public final This bind(String string, Byte by) {
        return this.bind(string, this.toArgument((Type)((Object)Byte.class), (Object)by));
    }

    public final This bind(int n, byte[] byArray) {
        return this.bind(n, this.toArgument((Type)((Object)byte[].class), (Object)byArray));
    }

    public final This bind(String string, byte[] byArray) {
        return this.bind(string, this.toArgument((Type)((Object)byte[].class), (Object)byArray));
    }

    public final This bind(int n, Reader reader, int n2) {
        return this.bind(n, (Argument)new CharacterStreamArgument(reader, n2));
    }

    public final This bind(String string, Reader reader, int n) {
        return this.bind(string, (Argument)new CharacterStreamArgument(reader, n));
    }

    public final This bind(int n, Clob clob) {
        return this.bind(n, this.toArgument((Type)((Object)Clob.class), (Object)clob));
    }

    public final This bind(String string, Clob clob) {
        return this.bind(string, this.toArgument((Type)((Object)Clob.class), (Object)clob));
    }

    public final This bind(int n, Date date) {
        return this.bind(n, this.toArgument((Type)((Object)Date.class), (Object)date));
    }

    public final This bind(String string, Date date) {
        return this.bind(string, this.toArgument((Type)((Object)Date.class), (Object)date));
    }

    public final This bind(int n, java.util.Date date) {
        return this.bind(n, this.toArgument((Type)((Object)java.util.Date.class), (Object)date));
    }

    public final This bind(String string, java.util.Date date) {
        return this.bind(string, this.toArgument((Type)((Object)java.util.Date.class), (Object)date));
    }

    public final This bind(int n, double d) {
        return this.bind(n, this.toArgument(Double.TYPE, (Object)d));
    }

    public final This bind(int n, Double d) {
        return this.bind(n, this.toArgument((Type)((Object)Double.class), (Object)d));
    }

    public final This bind(String string, double d) {
        return this.bind(string, this.toArgument(Double.TYPE, (Object)d));
    }

    public final This bind(String string, Double d) {
        return this.bind(string, this.toArgument((Type)((Object)Double.class), (Object)d));
    }

    public final This bind(int n, float f) {
        return this.bind(n, this.toArgument(Float.TYPE, (Object)Float.valueOf(f)));
    }

    public final This bind(int n, Float f) {
        return this.bind(n, this.toArgument((Type)((Object)Float.class), (Object)f));
    }

    public final This bind(String string, float f) {
        return this.bind(string, this.toArgument(Float.TYPE, (Object)Float.valueOf(f)));
    }

    public final This bind(String string, Float f) {
        return this.bind(string, this.toArgument((Type)((Object)Float.class), (Object)f));
    }

    public final This bind(int n, long l) {
        return this.bind(n, this.toArgument(Long.TYPE, (Object)l));
    }

    public final This bind(int n, Long l) {
        return this.bind(n, this.toArgument((Type)((Object)Long.class), (Object)l));
    }

    public final This bind(String string, long l) {
        return this.bind(string, this.toArgument(Long.TYPE, (Object)l));
    }

    public final This bind(String string, Long l) {
        return this.bind(string, this.toArgument((Type)((Object)Long.class), (Object)l));
    }

    public final This bind(int n, Short s) {
        return this.bind(n, this.toArgument((Type)((Object)Short.class), (Object)s));
    }

    public final This bind(int n, short s) {
        return this.bind(n, this.toArgument(Short.TYPE, (Object)s));
    }

    public final This bind(String string, short s) {
        return this.bind(string, this.toArgument(Short.TYPE, (Object)s));
    }

    public final This bind(String string, Short s) {
        return this.bind(string, this.toArgument(Short.TYPE, (Object)s));
    }

    public final This bind(int n, Object object) {
        return this.bind(n, this.toArgument(object));
    }

    public final This bind(String string, Object object) {
        return this.bind(string, this.toArgument(object));
    }

    public final This bind(int n, Time time) {
        return this.bind(n, this.toArgument((Type)((Object)Time.class), (Object)time));
    }

    public final This bind(String string, Time time) {
        return this.bind(string, this.toArgument((Type)((Object)Time.class), (Object)time));
    }

    public final This bind(int n, Timestamp timestamp) {
        return this.bind(n, this.toArgument((Type)((Object)Timestamp.class), (Object)timestamp));
    }

    public final This bind(String string, Timestamp timestamp) {
        return this.bind(string, this.toArgument((Type)((Object)Timestamp.class), (Object)timestamp));
    }

    public final This bind(int n, URL uRL) {
        return this.bind(n, this.toArgument((Type)((Object)URL.class), (Object)uRL));
    }

    public final This bind(String string, URL uRL) {
        return this.bind(string, this.toArgument((Type)((Object)URL.class), (Object)uRL));
    }

    public final This bindByType(int n, Object object, Type type) {
        return this.bind(n, this.toArgument(type, object));
    }

    public final This bindByType(int n, Object object, GenericType<?> genericType) {
        return this.bindByType(n, object, genericType.getType());
    }

    @Beta
    public final This bindByType(int n, Object object, QualifiedType<?> qualifiedType) {
        return this.bind(n, this.toArgument(qualifiedType, object));
    }

    public final This bindByType(String string, Object object, Type type) {
        return this.bind(string, this.toArgument(type, object));
    }

    public final This bindByType(String string, Object object, GenericType<?> genericType) {
        return this.bindByType(string, object, genericType.getType());
    }

    @Beta
    public final This bindByType(String string, Object object, QualifiedType<?> qualifiedType) {
        return this.bind(string, this.toArgument(qualifiedType, object));
    }

    private Argument toArgument(Object object) {
        return this.toArgument((Type)((Object)(object == null ? Object.class : object.getClass())), object);
    }

    private Argument toArgument(Type type, final Object object) {
        final Argument argument = this.getConfig(Arguments.class).findFor(type, object).orElseThrow(() -> this.factoryNotFound(type, object));
        try {
            boolean bl;
            boolean bl2 = bl = argument.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class;
            if (bl) {
                return argument;
            }
            return new Argument(){

                @Override
                public void apply(int n, PreparedStatement preparedStatement, StatementContext statementContext) {
                    argument.apply(n, preparedStatement, statementContext);
                }

                public String toString() {
                    return Objects.toString(object);
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Error("toString method does not exist, Object hierarchy is corrupt", noSuchMethodException);
        }
    }

    private Argument toArgument(QualifiedType<?> qualifiedType, Object object) {
        return this.getConfig(Arguments.class).findFor(qualifiedType, object).orElseThrow(() -> this.factoryNotFound(qualifiedType, object));
    }

    private UnsupportedOperationException factoryNotFound(Type type, Object object) {
        Object[] objectArray;
        if (type instanceof Class && (objectArray = ((Class)type).getTypeParameters()).length > 0) {
            return new UnsupportedOperationException("No type parameters found for erased type '" + type + Arrays.toString(objectArray) + "'. To bind a generic type, prefer using bindByType.");
        }
        return new UnsupportedOperationException("No argument factory registered for '" + object + "' of type " + type);
    }

    private UnsupportedOperationException factoryNotFound(QualifiedType<?> qualifiedType, Object object) {
        Object[] objectArray;
        Type type = qualifiedType.getType();
        if (type instanceof Class && (objectArray = ((Class)type).getTypeParameters()).length > 0) {
            return new UnsupportedOperationException("No type parameters found for erased type '" + type + Arrays.toString(objectArray) + "' with qualifiers '" + qualifiedType.getQualifiers() + "'. To bind a generic type, prefer using bindByType.");
        }
        return new UnsupportedOperationException("No argument factory registered for '" + object + "' of qualified type " + qualifiedType);
    }

    public final This bindNull(String string, int n) {
        return this.bind(string, (Argument)new NullArgument(n));
    }

    public final This bindNull(int n, int n2) {
        return this.bind(n, (Argument)new NullArgument(n2));
    }

    public final This bindBySqlType(String string, Object object, int n) {
        return this.bind(string, ObjectArgument.of(object, n));
    }

    public final This bindBySqlType(int n, Object object, int n2) {
        return this.bind(n, ObjectArgument.of(object, n2));
    }

    public final This bindList(String string, Object ... objectArray) {
        if (objectArray.length == 0) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindList was called with no vararg values.");
        }
        return this.bindList(string, Arrays.asList(objectArray));
    }

    public final This bindList(String string, List<?> list2) {
        if (list2.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindList was called with an empty list.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list2.size(); ++i) {
            String string2 = "__" + string + "_" + i;
            if (i > 0) {
                stringBuilder.append(',');
            }
            String string3 = this.getConfig().get(SqlStatements.class).getSqlParser().nameParameter(string2, this.getContext());
            stringBuilder.append(string3);
            this.bind(string2, list2.get(i));
        }
        return (This)((SqlStatement)this.define(string, stringBuilder.toString()));
    }

    public final This bindBeanList(String string, List<?> list2, List<String> list3) {
        if (list2.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindBeanList was called with no values.");
        }
        if (list3.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindBeanList was called with no properties.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        StatementContext statementContext = this.getContext();
        for (int i = 0; i < list2.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            Object obj = list2.get(i);
            BeanPropertyArguments beanPropertyArguments = new BeanPropertyArguments(null, obj);
            stringBuilder.append('(');
            for (int j = 0; j < list3.size(); ++j) {
                if (j > 0) {
                    stringBuilder.append(',');
                }
                String string2 = list3.get(j);
                String string3 = "__" + string + '_' + i + '_' + string2;
                stringBuilder.append(':').append(string3);
                Argument argument = beanPropertyArguments.find(string2, statementContext).orElseThrow(() -> new UnableToCreateStatementException("Unable to get " + string2 + " argument for " + obj, statementContext));
                this.bind(string3, argument);
            }
            stringBuilder.append(')');
        }
        return (This)((SqlStatement)this.define(string, stringBuilder.toString()));
    }

    public final This bindMethodsList(String string, Iterable<?> iterable, List<String> list2) {
        Iterator<?> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindMethodsList was called with no values.");
        }
        if (list2.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindMethodsList was called with no values.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        StatementContext statementContext = this.getContext();
        int n = 0;
        while (iterator.hasNext()) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            Object obj = iterator.next();
            ObjectMethodArguments objectMethodArguments = new ObjectMethodArguments(null, obj);
            stringBuilder.append('(');
            for (int i = 0; i < list2.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                String string2 = list2.get(i);
                String string3 = string + n + '.' + string2;
                stringBuilder.append(':').append(string3);
                Argument argument = objectMethodArguments.find(string2, statementContext).orElseThrow(() -> new UnableToCreateStatementException("Unable to get " + string2 + " argument for " + obj, statementContext));
                this.bind(string3, argument);
            }
            stringBuilder.append(')');
            ++n;
        }
        return (This)((SqlStatement)this.define(string, stringBuilder.toString()));
    }

    public final This defineList(String string, Object ... objectArray) {
        if (objectArray.length == 0) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".defineList was called with no vararg values.");
        }
        if (Stream.of(objectArray).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".defineList was called with a vararg array containing null values.");
        }
        return this.defineList(string, Arrays.asList(objectArray));
    }

    public final This defineList(String string, List<?> list2) {
        if (list2.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".defineList was called with an empty list.");
        }
        if (list2.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".defineList was called with a list containing null values.");
        }
        String string2 = list2.stream().map(Object::toString).collect(Collectors.joining(", "));
        return (This)((SqlStatement)this.define(string, string2));
    }

    @Beta
    public This defineNamedBindings() {
        return (This)((SqlStatement)this.addCustomizer(new DefineNamedBindingsStatementCustomizer()));
    }

    PreparedStatement internalExecute() {
        StatementContext statementContext = this.getContext();
        this.beforeTemplating();
        String string = this.getConfig(SqlStatements.class).getTemplateEngine().render(this.sql, statementContext);
        statementContext.setRenderedSql(string);
        ParsedSql parsedSql = this.getConfig(SqlStatements.class).getSqlParser().parse(string, statementContext);
        String string2 = parsedSql.getSql();
        statementContext.setParsedSql(parsedSql);
        try {
            this.stmt = this.getClass().isAssignableFrom(Call.class) ? this.handle.getStatementBuilder().createCall(this.handle.getConnection(), string2, statementContext) : this.handle.getStatementBuilder().create(this.handle.getConnection(), string2, statementContext);
            this.addCleanable(() -> this.handle.getStatementBuilder().close(this.handle.getConnection(), this.sql, this.stmt));
            this.getConfig(SqlStatements.class).customize(this.stmt);
        }
        catch (SQLException sQLException) {
            throw new UnableToCreateStatementException(sQLException, statementContext);
        }
        statementContext.setStatement(this.stmt);
        this.beforeBinding();
        ArgumentBinder.bind(parsedSql.getParameters(), this.getBinding(), this.stmt, statementContext);
        this.beforeExecution();
        try {
            SqlLoggerUtil.wrap(this.stmt::execute, statementContext, this.getConfig(SqlStatements.class).getSqlLogger());
        }
        catch (SQLException sQLException) {
            try {
                this.stmt.close();
            }
            catch (SQLException sQLException2) {
                sQLException.addSuppressed(sQLException2);
            }
            throw new UnableToExecuteStatementException(sQLException, statementContext);
        }
        this.afterExecution();
        return this.stmt;
    }

    <T> RowMapper<T> mapperForType(Class<T> clazz) {
        return this.mapperForType((Type)clazz);
    }

    <T> RowMapper<T> mapperForType(GenericType<T> genericType) {
        return this.mapperForType(genericType.getType());
    }

    RowMapper<?> mapperForType(Type type) {
        return this.getConfig(Mappers.class).findFor(type).orElseThrow(() -> new UnsupportedOperationException("No mapper registered for " + type));
    }

    void beforeTemplating() {
        this.callCustomizers(statementCustomizer -> statementCustomizer.beforeTemplating(this.stmt, this.getContext()));
    }

    void beforeBinding() {
        this.callCustomizers(statementCustomizer -> statementCustomizer.beforeBinding(this.stmt, this.getContext()));
    }

    void beforeExecution() {
        this.callCustomizers(statementCustomizer -> statementCustomizer.beforeExecution(this.stmt, this.getContext()));
    }

    void afterExecution() {
        this.callCustomizers(statementCustomizer -> statementCustomizer.afterExecution(this.stmt, this.getContext()));
    }
}

