/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.io.Closeable;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import javax.annotation.Nullable;
import me.glaremasters.guilds.libs.jdbi.v3.core.CloseException;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Arguments;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayArgumentStrategy;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayType;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.JdbiCollectors;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.ExtensionMethod;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericType;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMappers;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.Mappers;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMappers;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Binding;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Cleanable;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.ParsedSql;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlStatements;
import me.glaremasters.guilds.libs.jdbi.v3.meta.Beta;

public class StatementContext
implements Closeable {
    private final ConfigRegistry config;
    private final ExtensionMethod extensionMethod;
    private final Set<Cleanable> cleanables = new LinkedHashSet<Cleanable>();
    private String rawSql;
    private String renderedSql;
    private ParsedSql parsedSql;
    private PreparedStatement statement;
    private Connection connection;
    private Binding binding = new Binding();
    private boolean returningGeneratedKeys = false;
    private String[] generatedKeysColumnNames = new String[0];
    private boolean concurrentUpdatable = false;
    private Instant executionMoment;
    private Instant completionMoment;
    private Instant exceptionMoment;

    StatementContext() {
        this(new ConfigRegistry());
    }

    StatementContext(ConfigRegistry configRegistry) {
        this(configRegistry, null);
    }

    StatementContext(ConfigRegistry configRegistry, ExtensionMethod extensionMethod) {
        this.config = Objects.requireNonNull(configRegistry);
        this.extensionMethod = extensionMethod;
    }

    public <C extends JdbiConfig<C>> C getConfig(Class<C> clazz) {
        return this.config.get(clazz);
    }

    public ConfigRegistry getConfig() {
        return this.config;
    }

    public Map<String, Object> getAttributes() {
        return this.getConfig(SqlStatements.class).getAttributes();
    }

    public Object getAttribute(String string) {
        return this.getConfig(SqlStatements.class).getAttribute(string);
    }

    public void define(String string, Object object) {
        this.getConfig(SqlStatements.class).define(string, object);
    }

    public Optional<Argument> findArgumentFor(Type type, Object object) {
        return this.getConfig(Arguments.class).findFor(type, object);
    }

    @Beta
    public Optional<Argument> findArgumentFor(QualifiedType<?> qualifiedType, Object object) {
        return this.getConfig(Arguments.class).findFor(qualifiedType, object);
    }

    public SqlArrayArgumentStrategy getSqlArrayArgumentStrategy() {
        return this.getConfig(SqlArrayTypes.class).getArgumentStrategy();
    }

    public Optional<SqlArrayType<?>> findSqlArrayTypeFor(Type type) {
        return this.getConfig(SqlArrayTypes.class).findFor(type);
    }

    public <T> Optional<RowMapper<T>> findMapperFor(Class<T> clazz) {
        return this.getConfig(Mappers.class).findFor(clazz);
    }

    public <T> Optional<RowMapper<T>> findMapperFor(GenericType<T> genericType) {
        return this.getConfig(Mappers.class).findFor(genericType);
    }

    public Optional<RowMapper<?>> findMapperFor(Type type) {
        return this.getConfig(Mappers.class).findFor(type);
    }

    @Beta
    public <T> Optional<RowMapper<T>> findMapperFor(QualifiedType<T> qualifiedType) {
        return this.getConfig(Mappers.class).findFor(qualifiedType);
    }

    public <T> Optional<ColumnMapper<T>> findColumnMapperFor(Class<T> clazz) {
        return this.getConfig(ColumnMappers.class).findFor(clazz);
    }

    public <T> Optional<ColumnMapper<T>> findColumnMapperFor(GenericType<T> genericType) {
        return this.getConfig(ColumnMappers.class).findFor(genericType);
    }

    public Optional<ColumnMapper<?>> findColumnMapperFor(Type type) {
        return this.getConfig(ColumnMappers.class).findFor(type);
    }

    @Beta
    public <T> Optional<ColumnMapper<T>> findColumnMapperFor(QualifiedType<T> qualifiedType) {
        return this.getConfig(ColumnMappers.class).findFor(qualifiedType);
    }

    public Optional<RowMapper<?>> findRowMapperFor(Type type) {
        return this.getConfig(RowMappers.class).findFor(type);
    }

    public <T> Optional<RowMapper<T>> findRowMapperFor(Class<T> clazz) {
        return this.getConfig(RowMappers.class).findFor(clazz);
    }

    public <T> Optional<RowMapper<T>> findRowMapperFor(GenericType<T> genericType) {
        return this.getConfig(RowMappers.class).findFor(genericType);
    }

    public Optional<Collector<?, ?, ?>> findCollectorFor(Type type) {
        return this.getConfig(JdbiCollectors.class).findFor(type);
    }

    public Optional<Type> findElementTypeFor(Type type) {
        return this.getConfig(JdbiCollectors.class).findElementTypeFor(type);
    }

    StatementContext setRawSql(String string) {
        this.rawSql = string;
        return this;
    }

    public String getRawSql() {
        return this.rawSql;
    }

    void setRenderedSql(String string) {
        this.renderedSql = string;
    }

    public String getRenderedSql() {
        return this.renderedSql;
    }

    void setParsedSql(ParsedSql parsedSql) {
        this.parsedSql = parsedSql;
    }

    public ParsedSql getParsedSql() {
        return this.parsedSql;
    }

    void setStatement(PreparedStatement preparedStatement) {
        this.statement = preparedStatement;
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    StatementContext setConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public Connection getConnection() {
        return this.connection;
    }

    StatementContext setBinding(Binding binding) {
        this.binding = binding;
        return this;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setReturningGeneratedKeys(boolean bl) {
        if (this.isConcurrentUpdatable() && bl) {
            throw new IllegalArgumentException("Cannot create a result set that is concurrent updatable and is returning generated keys.");
        }
        this.returningGeneratedKeys = bl;
    }

    public boolean isReturningGeneratedKeys() {
        return this.returningGeneratedKeys || this.generatedKeysColumnNames.length > 0;
    }

    public String[] getGeneratedKeysColumnNames() {
        return Arrays.copyOf(this.generatedKeysColumnNames, this.generatedKeysColumnNames.length);
    }

    public void setGeneratedKeysColumnNames(String[] stringArray) {
        this.generatedKeysColumnNames = Arrays.copyOf(stringArray, stringArray.length);
    }

    public boolean isConcurrentUpdatable() {
        return this.concurrentUpdatable;
    }

    public void setConcurrentUpdatable(boolean bl) {
        if (bl && this.isReturningGeneratedKeys()) {
            throw new IllegalArgumentException("Cannot create a result set that is concurrent updatable and is returning generated keys.");
        }
        this.concurrentUpdatable = bl;
    }

    @Nullable
    public Instant getExecutionMoment() {
        return this.executionMoment;
    }

    public void setExecutionMoment(Instant instant) {
        this.executionMoment = instant;
    }

    @Nullable
    public Instant getCompletionMoment() {
        return this.completionMoment;
    }

    public void setCompletionMoment(Instant instant) {
        this.completionMoment = instant;
    }

    @Nullable
    public Instant getExceptionMoment() {
        return this.exceptionMoment;
    }

    public void setExceptionMoment(Instant instant) {
        this.exceptionMoment = instant;
    }

    public long getElapsedTime(ChronoUnit chronoUnit) {
        return chronoUnit.between(this.executionMoment, this.completionMoment == null ? this.exceptionMoment : this.completionMoment);
    }

    public void addCleanable(Cleanable cleanable) {
        this.cleanables.add(cleanable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SQLException sQLException = null;
        try {
            ArrayList<Cleanable> arrayList = new ArrayList<Cleanable>(this.cleanables);
            this.cleanables.clear();
            Collections.reverse(arrayList);
            for (Cleanable cleanable : arrayList) {
                try {
                    cleanable.close();
                }
                catch (SQLException sQLException2) {
                    if (sQLException == null) {
                        sQLException = sQLException2;
                        continue;
                    }
                    sQLException.addSuppressed(sQLException2);
                }
            }
        }
        finally {
            if (sQLException != null) {
                throw new CloseException("Exception thrown while cleaning StatementContext", sQLException);
            }
        }
    }

    public ExtensionMethod getExtensionMethod() {
        return this.extensionMethod;
    }
}

