/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.sql.PreparedStatement;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementCustomizer;

public final class StatementCustomizers {
    private StatementCustomizers() {
    }

    public static StatementCustomizer statementTimeout(final int n) {
        return new StatementCustomizer(){

            @Override
            public void beforeExecution(PreparedStatement preparedStatement, StatementContext statementContext) {
                preparedStatement.setQueryTimeout(n);
            }
        };
    }

    public static StatementCustomizer fetchSize(final int n) {
        return new StatementCustomizer(){

            @Override
            public void beforeExecution(PreparedStatement preparedStatement, StatementContext statementContext) {
                preparedStatement.setFetchSize(n);
            }
        };
    }

    public static StatementCustomizer maxRows(final int n) {
        return new StatementCustomizer(){

            @Override
            public void beforeExecution(PreparedStatement preparedStatement, StatementContext statementContext) {
                preparedStatement.setMaxRows(n);
            }
        };
    }

    public static StatementCustomizer maxFieldSize(final int n) {
        return new StatementCustomizer(){

            @Override
            public void beforeExecution(PreparedStatement preparedStatement, StatementContext statementContext) {
                preparedStatement.setMaxFieldSize(n);
            }
        };
    }
}

