/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.JdbiOptionals;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.BridgeMethodHandlerFactory;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.DefaultMethodHandlerFactory;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.Handler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.HandlerFactory;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.SqlMethodHandlerFactory;

public class Handlers
implements JdbiConfig<Handlers> {
    private final List<HandlerFactory> factories = new CopyOnWriteArrayList<HandlerFactory>();

    public Handlers() {
        this.register(new DefaultMethodHandlerFactory());
        this.register(new SqlMethodHandlerFactory());
        this.register(new BridgeMethodHandlerFactory());
    }

    private Handlers(Handlers handlers) {
        this.factories.addAll(handlers.factories);
    }

    public Handlers register(HandlerFactory handlerFactory) {
        this.factories.add(0, handlerFactory);
        return this;
    }

    public Optional<Handler> findFor(Class<?> clazz, Method method) {
        return this.factories.stream().flatMap(handlerFactory -> JdbiOptionals.stream(handlerFactory.buildHandler(clazz, method))).findFirst();
    }

    @Override
    public Handlers createCopy() {
        return new Handlers(this);
    }
}

