/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.exceptions.Sneaky;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.Handler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.HandlerFactory;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.SqlOperation;

class SqlMethodHandlerFactory
implements HandlerFactory {
    SqlMethodHandlerFactory() {
    }

    @Override
    public Optional<Handler> buildHandler(Class<?> clazz2, Method method) {
        List list2 = Stream.of(method.getAnnotations()).map(Annotation::annotationType).filter(clazz -> clazz.isAnnotationPresent(SqlOperation.class)).collect(Collectors.toList());
        if (list2.isEmpty()) {
            return Optional.empty();
        }
        if (list2.size() > 1) {
            throw new IllegalStateException(String.format("Mutually exclusive annotations on method %s.%s: %s", clazz2.getName(), method.getName(), list2));
        }
        if (method.isDefault() && !method.isSynthetic()) {
            throw new IllegalStateException(String.format("Default method %s.%s has @%s annotation. SQL object methods may be default, or have a SQL method annotation, but not both.", clazz2.getSimpleName(), method.getName(), ((Class)list2.get(0)).getSimpleName()));
        }
        return Optional.of(list2.stream().map(clazz -> clazz.getAnnotation(SqlOperation.class)).map(sqlOperation -> this.buildHandler(sqlOperation.value(), clazz2, method)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Method %s.%s must be default or be annotated with a SQL method annotation.", clazz2.getSimpleName(), method.getName()))));
    }

    private Handler buildHandler(Class<? extends Handler> clazz, Class<?> clazz2, Method method) {
        try {
            return clazz.getConstructor(Class.class, Method.class).newInstance(clazz2, method);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Sneaky.throwAnyway(invocationTargetException.getCause());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            try {
                return clazz.getConstructor(Method.class).newInstance(method);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw Sneaky.throwAnyway(invocationTargetException.getCause());
            }
            catch (ReflectiveOperationException reflectiveOperationException2) {
                try {
                    return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw Sneaky.throwAnyway(invocationTargetException.getCause());
                }
                catch (ReflectiveOperationException reflectiveOperationException3) {
                    throw new IllegalStateException("Handler class " + clazz + " cannot be instantiated. Expected a constructor with parameters (Class, Method), (Method), or ().", reflectiveOperationException3);
                }
            }
        }
    }
}

