/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.HandleSupplier;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.RowReducer;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlStatement;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToCreateStatementException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToExecuteStatementException;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.Handler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.SqlObjects;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.ParameterCustomizerFactory;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.UseRowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.UseRowReducer;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

abstract class CustomizingStatementHandler<StatementType extends SqlStatement<StatementType>>
implements Handler {
    private final List<BoundCustomizer> statementCustomizers;
    private final Class<?> sqlObjectType;
    private final Method method;

    CustomizingStatementHandler(Class<?> clazz, Method method) {
        this.sqlObjectType = clazz;
        this.method = method;
        Stream<BoundCustomizer> stream = Stream.concat(Stream.of(clazz.getInterfaces()), Stream.of(clazz)).flatMap(annotatedElement -> CustomizingStatementHandler.annotationsFor(annotatedElement)).map(annotation -> CustomizingStatementHandler.instantiateFactory(annotation).createForType((Annotation)annotation, clazz)).map(BoundCustomizer::of);
        Stream<BoundCustomizer> stream2 = CustomizingStatementHandler.annotationsFor(method).map(annotation -> CustomizingStatementHandler.instantiateFactory(annotation).createForMethod((Annotation)annotation, clazz, method)).map(BoundCustomizer::of);
        Stream<BoundCustomizer> stream3 = this.parameterCustomizers(clazz, method);
        this.statementCustomizers = Stream.of(stream, stream2, stream3).reduce(Stream.empty(), Stream::concat).collect(Collectors.toList());
    }

    private static Stream<Annotation> annotationsFor(AnnotatedElement ... annotatedElementArray) {
        return Stream.of(annotatedElementArray).map(AnnotatedElement::getAnnotations).flatMap(Stream::of).filter(annotation -> annotation.annotationType().isAnnotationPresent(SqlStatementCustomizingAnnotation.class));
    }

    private Stream<BoundCustomizer> parameterCustomizers(Class<?> clazz, Method method) {
        Parameter[] parameterArray = method.getParameters();
        return IntStream.range(0, parameterArray.length).boxed().flatMap(n -> this.eachParameterCustomizers(clazz, method, parameterArray[n], (Integer)n));
    }

    private Stream<BoundCustomizer> eachParameterCustomizers(Class<?> clazz, Method method, Parameter parameter, Integer n) {
        List list2 = CustomizingStatementHandler.annotationsFor(parameter).map(annotation -> CustomizingStatementHandler.instantiateFactory(annotation).createForParameter((Annotation)annotation, clazz, method, parameter, n, this.getParameterType(parameter))).map(sqlStatementParameterCustomizer -> (sqlStatement, objectArray) -> sqlStatementParameterCustomizer.apply(sqlStatement, objectArray[n])).collect(Collectors.toList());
        if (!list2.isEmpty()) {
            return list2.stream();
        }
        if (parameter.getType() == Consumer.class) {
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalStateException("SQL Object methods with a Consumer parameter must have void return type.");
            }
            return Stream.empty();
        }
        return Stream.of(this.defaultParameterCustomizer(clazz, method, parameter, n));
    }

    private BoundCustomizer defaultParameterCustomizer(Class<?> clazz, Method method, Parameter parameter, Integer n) {
        return (sqlStatement, objectArray) -> CustomizingStatementHandler.getDefaultParameterCustomizerFactory(sqlStatement).createForParameter(clazz, method, parameter, n, this.getParameterType(parameter)).apply(sqlStatement, objectArray[n]);
    }

    Type getParameterType(Parameter parameter) {
        return GenericTypes.resolveType(parameter.getParameterizedType(), this.sqlObjectType);
    }

    private static ParameterCustomizerFactory getDefaultParameterCustomizerFactory(SqlStatement<?> sqlStatement) {
        return sqlStatement.getConfig(SqlObjects.class).getDefaultParameterCustomizerFactory();
    }

    private static SqlStatementCustomizerFactory instantiateFactory(Annotation annotation) {
        SqlStatementCustomizingAnnotation sqlStatementCustomizingAnnotation = annotation.annotationType().getAnnotation(SqlStatementCustomizingAnnotation.class);
        try {
            return sqlStatementCustomizingAnnotation.value().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new IllegalStateException("unable to instantiate sql statement customizer factory", reflectiveOperationException);
        }
    }

    @Override
    public Object invoke(Object object, Object[] objectArray, HandleSupplier handleSupplier) {
        Handle handle = handleSupplier.getHandle();
        String string = this.locateSql(handle);
        StatementType StatementType = this.createStatement(handle, string);
        SqlObjectStatementConfiguration sqlObjectStatementConfiguration = StatementType.getConfig(SqlObjectStatementConfiguration.class);
        sqlObjectStatementConfiguration.setArgs(objectArray);
        this.configureReturner(StatementType, sqlObjectStatementConfiguration);
        this.applyCustomizers(StatementType, objectArray);
        return sqlObjectStatementConfiguration.getReturner().get();
    }

    void applyCustomizers(StatementType StatementType, Object[] objectArray) {
        this.statementCustomizers.forEach(boundCustomizer -> {
            try {
                boundCustomizer.apply((SqlStatement<?>)StatementType, objectArray);
            }
            catch (SQLException sQLException) {
                throw new UnableToExecuteStatementException(sQLException, StatementType.getContext());
            }
        });
    }

    abstract void configureReturner(StatementType var1, SqlObjectStatementConfiguration var2);

    abstract StatementType createStatement(Handle var1, String var2);

    String locateSql(Handle handle) {
        return handle.getConfig(SqlObjects.class).getSqlLocator().locate(this.sqlObjectType, this.method, handle.getConfig());
    }

    Method getMethod() {
        return this.method;
    }

    static RowMapper<?> rowMapperFor(UseRowMapper useRowMapper) {
        Class<RowMapper<?>> clazz = useRowMapper.value();
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new UnableToCreateStatementException("Could not create mapper " + clazz.getName(), exception, null);
        }
    }

    static RowReducer<?, ?> rowReducerFor(UseRowReducer useRowReducer) {
        Class<RowReducer<?, ?>> clazz = useRowReducer.value();
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new UnableToCreateStatementException("Could not create reducer " + clazz.getName(), exception, null);
        }
    }

    private static interface BoundCustomizer {
        public void apply(SqlStatement<?> var1, Object[] var2) throws SQLException;

        public static BoundCustomizer of(SqlStatementCustomizer c) {
            return (stmt, args) -> c.apply(stmt);
        }
    }
}

