/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Call;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.OutParameters;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.CustomizingStatementHandler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class SqlCallHandler
extends CustomizingStatementHandler<Call> {
    private final boolean returnOutParams;

    public SqlCallHandler(Class<?> clazz, Method method) {
        super(clazz, method);
        Type type = GenericTypes.resolveType(method.getGenericReturnType(), clazz);
        Class<?> clazz2 = GenericTypes.getErasedType(type);
        if (Void.TYPE.equals(clazz2)) {
            this.returnOutParams = false;
        } else if (OutParameters.class.isAssignableFrom(clazz2)) {
            this.returnOutParams = true;
        } else {
            throw new IllegalArgumentException("@SqlCall methods may only return null or OutParameters at present");
        }
    }

    @Override
    Call createStatement(Handle handle, String string) {
        return handle.createCall(string);
    }

    @Override
    void configureReturner(Call call, SqlObjectStatementConfiguration sqlObjectStatementConfiguration) {
        sqlObjectStatementConfiguration.setReturner(() -> {
            OutParameters outParameters = call.invoke();
            if (this.returnOutParams) {
                return outParameters;
            }
            return null;
        });
    }
}

