/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.kyori.adventure.text.flattener;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import me.glaremasters.guilds.libs.kyori.adventure.text.Component;
import me.glaremasters.guilds.libs.kyori.adventure.text.KeybindComponent;
import me.glaremasters.guilds.libs.kyori.adventure.text.ScoreComponent;
import me.glaremasters.guilds.libs.kyori.adventure.text.SelectorComponent;
import me.glaremasters.guilds.libs.kyori.adventure.text.TextComponent;
import me.glaremasters.guilds.libs.kyori.adventure.text.TranslatableComponent;
import me.glaremasters.guilds.libs.kyori.adventure.text.flattener.ComponentFlattener;
import me.glaremasters.guilds.libs.kyori.adventure.text.flattener.FlattenerListener;
import me.glaremasters.guilds.libs.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ComponentFlattenerImpl
implements ComponentFlattener {
    static final ComponentFlattener BASIC = (ComponentFlattener)new BuilderImpl().mapper(KeybindComponent.class, keybindComponent -> keybindComponent.keybind()).mapper(ScoreComponent.class, ScoreComponent::value).mapper(SelectorComponent.class, SelectorComponent::pattern).mapper(TextComponent.class, TextComponent::content).mapper(TranslatableComponent.class, TranslatableComponent::key).build();
    static final ComponentFlattener TEXT_ONLY = (ComponentFlattener)new BuilderImpl().mapper(TextComponent.class, TextComponent::content).build();
    private static final int MAX_DEPTH = 512;
    private final Map<Class<?>, Function<?, String>> flatteners;
    private final Map<Class<?>, BiConsumer<?, Consumer<Component>>> complexFlatteners;
    private final ConcurrentMap<Class<?>, Handler> propagatedFlatteners = new ConcurrentHashMap();
    private final Function<Component, String> unknownHandler;

    ComponentFlattenerImpl(Map<Class<?>, Function<?, String>> map, Map<Class<?>, BiConsumer<?, Consumer<Component>>> map2, @Nullable Function<Component, String> function) {
        this.flatteners = Collections.unmodifiableMap(new HashMap(map));
        this.complexFlatteners = Collections.unmodifiableMap(new HashMap(map2));
        this.unknownHandler = function;
    }

    @Override
    public void flatten(@NotNull Component component, @NotNull FlattenerListener flattenerListener) {
        this.flatten0(component, flattenerListener, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flatten0(@NotNull Component component, @NotNull FlattenerListener flattenerListener, int n) {
        Objects.requireNonNull(component, "input");
        Objects.requireNonNull(flattenerListener, "listener");
        if (component == Component.empty()) {
            return;
        }
        if (n > 512) {
            throw new IllegalStateException("Exceeded maximum depth of 512 while attempting to flatten components!");
        }
        @Nullable Handler handler = this.flattener(component);
        Style style = component.style();
        flattenerListener.pushStyle(style);
        try {
            if (handler != null) {
                handler.handle(component, flattenerListener, n + 1);
            }
            if (!component.children().isEmpty()) {
                for (Component component2 : component.children()) {
                    this.flatten0(component2, flattenerListener, n + 1);
                }
            }
        }
        finally {
            flattenerListener.popStyle(style);
        }
    }

    @Nullable
    private <T extends Component> Handler flattener(T t) {
        Handler handler = this.propagatedFlatteners.computeIfAbsent(t.getClass(), clazz -> {
            @Nullable Function<?, String> function = this.flatteners.get(clazz);
            if (function != null) {
                return (component, flattenerListener, n) -> flattenerListener.component((String)function.apply(component));
            }
            for (Map.Entry<Class<?>, Function<?, String>> entry : this.flatteners.entrySet()) {
                if (!entry.getKey().isAssignableFrom((Class<?>)clazz)) continue;
                return (component, flattenerListener, n) -> flattenerListener.component((String)((Function)entry.getValue()).apply(component));
            }
            BiConsumer<?, Consumer<Component>> biConsumer = this.complexFlatteners.get(clazz);
            if (biConsumer != null) {
                return (component2, flattenerListener, n) -> biConsumer.accept(component2, component -> this.flatten0((Component)component, flattenerListener, n));
            }
            for (Map.Entry entry : this.complexFlatteners.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom((Class<?>)clazz)) continue;
                return (component2, flattenerListener, n) -> ((BiConsumer)entry.getValue()).accept(component2, component -> this.flatten0((Component)component, flattenerListener, n));
            }
            return Handler.NONE;
        });
        if (handler == Handler.NONE) {
            return this.unknownHandler == null ? null : (component, flattenerListener, n) -> flattenerListener.component(this.unknownHandler.apply(component));
        }
        return handler;
    }

    @Override
    public @NotNull ComponentFlattener.Builder toBuilder() {
        return new BuilderImpl(this.flatteners, this.complexFlatteners, this.unknownHandler);
    }

    static final class BuilderImpl
    implements ComponentFlattener.Builder {
        private final Map<Class<?>, Function<?, String>> flatteners;
        private final Map<Class<?>, BiConsumer<?, Consumer<Component>>> complexFlatteners;
        @Nullable
        private Function<Component, String> unknownHandler;

        BuilderImpl() {
            this.flatteners = new HashMap();
            this.complexFlatteners = new HashMap();
        }

        BuilderImpl(Map<Class<?>, Function<?, String>> map, Map<Class<?>, BiConsumer<?, Consumer<Component>>> map2, @Nullable Function<Component, String> function) {
            this.flatteners = new HashMap(map);
            this.complexFlatteners = new HashMap(map2);
            this.unknownHandler = function;
        }

        @Override
        @NotNull
        public ComponentFlattener build() {
            return new ComponentFlattenerImpl(this.flatteners, this.complexFlatteners, this.unknownHandler);
        }

        @Override
        public <T extends Component> @NotNull ComponentFlattener.Builder mapper(@NotNull Class<T> clazz, @NotNull Function<T, String> function) {
            this.validateNoneInHierarchy(Objects.requireNonNull(clazz, "type"));
            this.flatteners.put(clazz, Objects.requireNonNull(function, "converter"));
            this.complexFlatteners.remove(clazz);
            return this;
        }

        @Override
        public <T extends Component> @NotNull ComponentFlattener.Builder complexMapper(@NotNull Class<T> clazz, @NotNull BiConsumer<T, Consumer<Component>> biConsumer) {
            this.validateNoneInHierarchy(Objects.requireNonNull(clazz, "type"));
            this.complexFlatteners.put(clazz, Objects.requireNonNull(biConsumer, "converter"));
            this.flatteners.remove(clazz);
            return this;
        }

        private void validateNoneInHierarchy(Class<? extends Component> clazz) {
            for (Class<?> clazz2 : this.flatteners.keySet()) {
                BuilderImpl.testHierarchy(clazz2, clazz);
            }
            for (Class<?> clazz2 : this.complexFlatteners.keySet()) {
                BuilderImpl.testHierarchy(clazz2, clazz);
            }
        }

        private static void testHierarchy(Class<?> clazz, Class<?> clazz2) {
            if (!clazz.equals(clazz2) && (clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz))) {
                throw new IllegalArgumentException("Conflict detected between already registered type " + clazz + " and newly registered type " + clazz2 + "! Types in a component flattener must not share a common hierarchy!");
            }
        }

        @Override
        public @NotNull ComponentFlattener.Builder unknownMapper(@Nullable Function<Component, String> function) {
            this.unknownHandler = function;
            return this;
        }
    }

    @FunctionalInterface
    static interface Handler {
        public static final Handler NONE = (input, listener, depth) -> {};

        public void handle(Component var1, FlattenerListener var2, int var3);
    }
}

