/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.app.builder;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.function.Function;
import me.glaremasters.guilds.libs.slimjar.app.AppendingApplication;
import me.glaremasters.guilds.libs.slimjar.app.Application;
import me.glaremasters.guilds.libs.slimjar.app.builder.ApplicationBuilder;
import me.glaremasters.guilds.libs.slimjar.injector.DependencyInjector;
import me.glaremasters.guilds.libs.slimjar.injector.loader.Injectable;
import me.glaremasters.guilds.libs.slimjar.injector.loader.InjectableFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.ResolutionResult;
import me.glaremasters.guilds.libs.slimjar.resolver.data.DependencyData;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.dependency.DependencyDataProvider;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.resolution.PreResolutionDataProvider;

public final class InjectingApplicationBuilder
extends ApplicationBuilder {
    private final Function<ApplicationBuilder, Injectable> injectableSupplier;

    public InjectingApplicationBuilder(String string, Injectable injectable) {
        this(string, (ApplicationBuilder applicationBuilder) -> injectable);
    }

    public InjectingApplicationBuilder(String string, Function<ApplicationBuilder, Injectable> function) {
        super(string);
        this.injectableSupplier = function;
    }

    @Override
    public Application buildApplication() {
        DependencyDataProvider dependencyDataProvider = this.getDataProviderFactory().create(this.getDependencyFileUrl());
        DependencyData dependencyData = dependencyDataProvider.get();
        DependencyInjector dependencyInjector = this.createInjector();
        PreResolutionDataProvider preResolutionDataProvider = this.getPreResolutionDataProviderFactory().create(this.getPreResolutionFileUrl());
        Map<String, ResolutionResult> map = preResolutionDataProvider.get();
        dependencyInjector.inject(this.injectableSupplier.apply(this), dependencyData, map);
        return new AppendingApplication();
    }

    public static ApplicationBuilder createAppending(String string) {
        ClassLoader classLoader = ApplicationBuilder.class.getClassLoader();
        return InjectingApplicationBuilder.createAppending(string, classLoader);
    }

    public static ApplicationBuilder createAppending(String string, ClassLoader classLoader) {
        return new InjectingApplicationBuilder(string, applicationBuilder -> {
            try {
                return InjectableFactory.create(applicationBuilder.getDownloadDirectoryPath(), applicationBuilder.getInternalRepositories(), classLoader);
            }
            catch (IOException | ReflectiveOperationException | URISyntaxException | NoSuchAlgorithmException exception) {
                exception.printStackTrace();
                return null;
            }
        });
    }
}

