/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.app.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import me.glaremasters.guilds.libs.slimjar.app.module.ModuleExtractor;
import me.glaremasters.guilds.libs.slimjar.app.module.TemporaryModuleExtractor;
import me.glaremasters.guilds.libs.slimjar.util.Modules;

public final class IsolationConfiguration {
    private final String applicationClass;
    private final Collection<String> modules;
    private final ClassLoader parentClassloader;
    private final ModuleExtractor moduleExtractor;

    public IsolationConfiguration(String string, Collection<String> collection, ClassLoader classLoader, ModuleExtractor moduleExtractor) {
        this.applicationClass = string;
        this.modules = Collections.unmodifiableCollection(collection);
        this.parentClassloader = classLoader;
        this.moduleExtractor = moduleExtractor;
    }

    public String getApplicationClass() {
        return this.applicationClass;
    }

    public Collection<String> getModules() {
        return this.modules;
    }

    public ClassLoader getParentClassloader() {
        return this.parentClassloader;
    }

    public ModuleExtractor getModuleExtractor() {
        return this.moduleExtractor;
    }

    public static Builder builder(String string) {
        return new Builder().applicationClass(string);
    }

    public static final class Builder {
        private String applicationClass;
        private Collection<String> modules = new HashSet<String>();
        private ClassLoader parentClassloader;
        private ModuleExtractor moduleExtractor;

        public Builder applicationClass(String string) {
            this.applicationClass = string;
            return this;
        }

        public Builder modules(Collection<String> collection) {
            HashSet<String> hashSet = new HashSet<String>(collection);
            hashSet.addAll(collection);
            this.modules = hashSet;
            return this;
        }

        public Builder module(String string) {
            this.modules.add(string);
            return this;
        }

        public Builder parentClassLoader(ClassLoader classLoader) {
            this.parentClassloader = classLoader;
            return this;
        }

        public Builder moduleExtractor(ModuleExtractor moduleExtractor) {
            this.moduleExtractor = moduleExtractor;
            return this;
        }

        String getApplicationClass() {
            if (this.applicationClass == null) {
                throw new AssertionError((Object)"Application Class not Provided!");
            }
            return this.applicationClass;
        }

        Collection<String> getModules() {
            if (this.modules == null || this.modules.isEmpty()) {
                this.modules = Modules.findLocalModules();
            }
            return this.modules;
        }

        ClassLoader getParentClassloader() {
            if (this.parentClassloader == null) {
                this.parentClassloader = ClassLoader.getSystemClassLoader().getParent();
            }
            return this.parentClassloader;
        }

        ModuleExtractor getModuleExtractor() {
            if (this.moduleExtractor == null) {
                this.moduleExtractor = new TemporaryModuleExtractor();
            }
            return this.moduleExtractor;
        }

        public IsolationConfiguration build() {
            return new IsolationConfiguration(this.getApplicationClass(), this.getModules(), this.getParentClassloader(), this.getModuleExtractor());
        }
    }
}

