/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.downloader.strategy;

import java.io.File;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.glaremasters.guilds.libs.slimjar.downloader.strategy.FilePathStrategy;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;

public final class FolderedFilePathStrategy
implements FilePathStrategy {
    private static final Logger LOGGER = Logger.getLogger(FolderedFilePathStrategy.class.getName());
    private static final String DEPENDENCY_FILE_FORMAT = "%s/%s/%s/%s/%3$s-%4$s.jar";
    private final File rootDirectory;

    private FolderedFilePathStrategy(File file) {
        this.rootDirectory = file;
    }

    @Override
    public File selectFileFor(Dependency dependency) {
        String string2 = Optional.ofNullable(dependency.getSnapshotId()).map(string -> "-" + string).orElse("");
        String string3 = String.format(DEPENDENCY_FILE_FORMAT, this.rootDirectory.getPath(), dependency.getGroupId().replace('.', '/'), dependency.getArtifactId(), dependency.getVersion() + string2);
        LOGGER.log(Level.FINEST, "Selected jar file for " + dependency.getArtifactId() + " at " + string3);
        return new File(string3);
    }

    public static FilePathStrategy createStrategy(File file) {
        boolean bl;
        if (!file.exists() && !(bl = file.mkdirs())) {
            throw new IllegalArgumentException("Could not create specified directory: " + file);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Expecting a directory for download root! " + file);
        }
        return new FolderedFilePathStrategy(file);
    }
}

