/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.resolver;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.slimjar.logging.LogDispatcher;
import me.glaremasters.guilds.libs.slimjar.logging.ProcessLogger;
import me.glaremasters.guilds.libs.slimjar.resolver.DependencyResolver;
import me.glaremasters.guilds.libs.slimjar.resolver.ResolutionResult;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;
import me.glaremasters.guilds.libs.slimjar.resolver.enquirer.RepositoryEnquirer;
import me.glaremasters.guilds.libs.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.pinger.URLPinger;

public final class CachingDependencyResolver
implements DependencyResolver {
    private static final String FAILED_RESOLUTION_MESSAGE = "[FAILED TO RESOLVE]";
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final URLPinger urlPinger;
    private final Collection<RepositoryEnquirer> repositories;
    private final Map<Dependency, ResolutionResult> cachedResults = new ConcurrentHashMap<Dependency, ResolutionResult>();
    private final Map<String, ResolutionResult> preResolvedResults;

    public CachingDependencyResolver(URLPinger uRLPinger, Collection<Repository> collection, RepositoryEnquirerFactory repositoryEnquirerFactory, Map<String, ResolutionResult> map) {
        this.urlPinger = uRLPinger;
        this.preResolvedResults = new ConcurrentHashMap<String, ResolutionResult>(map);
        this.repositories = collection.stream().map(repositoryEnquirerFactory::create).collect(Collectors.toSet());
    }

    @Override
    public Optional<ResolutionResult> resolve(Dependency dependency) {
        return Optional.ofNullable(this.cachedResults.computeIfAbsent(dependency, this::attemptResolve));
    }

    private ResolutionResult attemptResolve(Dependency dependency) {
        Object object;
        ResolutionResult resolutionResult = this.preResolvedResults.get(dependency.toString());
        if (resolutionResult != null) {
            boolean bl;
            if (resolutionResult.isAggregator()) {
                return resolutionResult;
            }
            boolean bl2 = this.urlPinger.ping(resolutionResult.getDependencyURL());
            object = resolutionResult.getChecksumURL();
            boolean bl3 = bl = object == null || this.urlPinger.ping((URL)object);
            if (bl2 && bl) {
                return resolutionResult;
            }
        }
        Optional<ResolutionResult> optional = ((Stream)this.repositories.stream().parallel()).map(repositoryEnquirer -> repositoryEnquirer.enquire(dependency)).filter(Objects::nonNull).findFirst();
        object = optional.map(ResolutionResult::getDependencyURL).map(Objects::toString).orElse(FAILED_RESOLUTION_MESSAGE);
        LOGGER.log("Resolved {0} @ {1}", dependency.getArtifactId(), object);
        return optional.orElse(null);
    }
}

