/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.resolver.enquirer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import me.glaremasters.guilds.libs.slimjar.logging.LogDispatcher;
import me.glaremasters.guilds.libs.slimjar.logging.ProcessLogger;
import me.glaremasters.guilds.libs.slimjar.resolver.ResolutionResult;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;
import me.glaremasters.guilds.libs.slimjar.resolver.enquirer.RepositoryEnquirer;
import me.glaremasters.guilds.libs.slimjar.resolver.pinger.URLPinger;
import me.glaremasters.guilds.libs.slimjar.resolver.strategy.PathResolutionStrategy;

public final class PingingRepositoryEnquirer
implements RepositoryEnquirer {
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final Repository repository;
    private final PathResolutionStrategy dependencyURLCreationStrategy;
    private final PathResolutionStrategy checksumURLCreationStrategy;
    private final PathResolutionStrategy pomURLCreationStrategy;
    private final URLPinger urlPinger;

    public PingingRepositoryEnquirer(Repository repository, PathResolutionStrategy pathResolutionStrategy, PathResolutionStrategy pathResolutionStrategy2, PathResolutionStrategy pathResolutionStrategy3, URLPinger uRLPinger) {
        this.repository = repository;
        this.dependencyURLCreationStrategy = pathResolutionStrategy;
        this.checksumURLCreationStrategy = pathResolutionStrategy2;
        this.pomURLCreationStrategy = pathResolutionStrategy3;
        this.urlPinger = uRLPinger;
    }

    @Override
    public ResolutionResult enquire(Dependency dependency) {
        LOGGER.debug("Enquiring repositories to find {0}", dependency.getArtifactId());
        Optional<URL> optional = this.dependencyURLCreationStrategy.pathTo(this.repository, dependency).stream().map(string -> {
            try {
                return new URL((String)string);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }).filter(this.urlPinger::ping).findFirst();
        if (!optional.isPresent()) {
            return this.pomURLCreationStrategy.pathTo(this.repository, dependency).stream().map(string -> {
                try {
                    return new URL((String)string);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }).filter(this.urlPinger::ping).findFirst().map(uRL -> new ResolutionResult(this.repository, null, null, true)).orElse(null);
        }
        Optional<URL> optional2 = this.checksumURLCreationStrategy.pathTo(this.repository, dependency).stream().map(string -> {
            try {
                return new URL((String)string);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }).filter(this.urlPinger::ping).findFirst();
        return new ResolutionResult(this.repository, optional.get(), optional2.orElse(null), false);
    }
}

