/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.resolver.pinger;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import me.glaremasters.guilds.libs.slimjar.logging.LogDispatcher;
import me.glaremasters.guilds.libs.slimjar.logging.ProcessLogger;
import me.glaremasters.guilds.libs.slimjar.resolver.pinger.URLPinger;

public final class HttpURLPinger
implements URLPinger {
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private static final String SLIMJAR_USER_AGENT = "SlimjarApplication/* URL Validation Ping";
    private static final Collection<String> SUPPORTED_PROTOCOLS = Arrays.asList("HTTP", "HTTPS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ping(URL uRL) {
        String string = uRL.toString();
        LOGGER.debug("Pinging {0}", string);
        if (!this.isSupported(uRL)) {
            LOGGER.debug("Protocol not supported for {0}", uRL.toString());
            return false;
        }
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.addRequestProperty("User-Agent", SLIMJAR_USER_AGENT);
            httpURLConnection.connect();
            boolean bl = httpURLConnection.getResponseCode() == 200;
            LOGGER.debug("Ping {1} for {0}", uRL.toString(), bl ? "successful" : "failed");
            boolean bl2 = httpURLConnection.getResponseCode() == 200;
            return bl2;
        }
        catch (IOException iOException) {
            LOGGER.debug("Ping failed for {0}", uRL.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    @Override
    public boolean isSupported(URL uRL) {
        String string = uRL.getProtocol().toUpperCase(Locale.ENGLISH);
        return SUPPORTED_PROTOCOLS.contains(string);
    }
}

