/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.resolver.strategy;

import java.util.Arrays;
import java.util.Collection;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;
import me.glaremasters.guilds.libs.slimjar.resolver.strategy.PathResolutionStrategy;
import me.glaremasters.guilds.libs.slimjar.util.Repositories;

public final class MavenSnapshotPathResolutionStrategy
implements PathResolutionStrategy {
    private static final String PATH_FORMAT_ALT = "%s%s/%s/%s-SNAPSHOT/%4$s-%s/%3$s-%4$s-%5$s.jar";
    private static final String PATH_FORMAT = "%s%s/%s/%s-SNAPSHOT/%3$s-%4$s-%5$s.jar";

    @Override
    public Collection<String> pathTo(Repository repository, Dependency dependency) {
        String string = Repositories.fetchFormattedUrl(repository);
        String string2 = dependency.getVersion().replace("-SNAPSHOT", "");
        String string3 = String.format(PATH_FORMAT_ALT, string, dependency.getGroupId().replace('.', '/'), dependency.getArtifactId(), string2, dependency.getSnapshotId());
        String string4 = String.format(PATH_FORMAT, string, dependency.getGroupId().replace('.', '/'), dependency.getArtifactId(), string2, dependency.getSnapshotId());
        return Arrays.asList(string4, string3);
    }
}

