/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.listeners;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.challenges.ChallengeHandler;
import me.glaremasters.guilds.configuration.sections.WarSettings;
import me.glaremasters.guilds.guild.GuildChallenge;
import me.glaremasters.guilds.libs.commands.ACFBukkitUtil;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.messages.Messages;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0007J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u0011H\u0007J\f\u0010\u0012\u001a\u00020\u000e*\u00020\u0013H\u0007J\f\u0010\u0014\u001a\u00020\u000e*\u00020\u0015H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/glaremasters/guilds/listeners/ArenaListener;", "Lorg/bukkit/event/Listener;", "guilds", "Lme/glaremasters/guilds/Guilds;", "challengeHandler", "Lme/glaremasters/guilds/challenges/ChallengeHandler;", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "(Lme/glaremasters/guilds/Guilds;Lme/glaremasters/guilds/challenges/ChallengeHandler;Lch/jalu/configme/SettingsManager;)V", "playerDeath", "", "Ljava/util/UUID;", "", "onCommand", "", "Lorg/bukkit/event/player/PlayerCommandPreprocessEvent;", "onDeath", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onRespawn", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "Guilds"})
public final class ArenaListener
implements Listener {
    @NotNull
    private final Guilds guilds;
    @NotNull
    private final ChallengeHandler challengeHandler;
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final Map<UUID, String> playerDeath;

    public ArenaListener(@NotNull Guilds guilds, @NotNull ChallengeHandler challengeHandler, @NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"guilds");
        Intrinsics.checkNotNullParameter((Object)challengeHandler, (String)"challengeHandler");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        this.guilds = guilds;
        this.challengeHandler = challengeHandler;
        this.settingsManager = settingsManager;
        this.playerDeath = new LinkedHashMap();
    }

    @EventHandler
    public final void onQuit(@NotNull PlayerQuitEvent playerQuitEvent) {
        Intrinsics.checkNotNullParameter((Object)playerQuitEvent, (String)"<this>");
        GuildChallenge guildChallenge = this.challengeHandler.getChallenge(playerQuitEvent.getPlayer());
        if (guildChallenge == null) {
            return;
        }
        GuildChallenge guildChallenge2 = guildChallenge;
        this.challengeHandler.announceDeath(guildChallenge2, this.guilds, playerQuitEvent.getPlayer(), playerQuitEvent.getPlayer(), ChallengeHandler.Cause.PLAYER_KILLED_QUIT);
        this.challengeHandler.handleFinish(this.guilds, this.settingsManager, playerQuitEvent.getPlayer(), guildChallenge2);
    }

    @EventHandler
    public final void onDeath(@NotNull PlayerDeathEvent playerDeathEvent) {
        Intrinsics.checkNotNullParameter((Object)playerDeathEvent, (String)"<this>");
        GuildChallenge guildChallenge = this.challengeHandler.getChallenge(playerDeathEvent.getEntity());
        if (guildChallenge == null) {
            return;
        }
        GuildChallenge guildChallenge2 = guildChallenge;
        if (!guildChallenge2.isStarted()) {
            return;
        }
        Boolean bl = this.settingsManager.getProperty(WarSettings.KEEP_INVENTORY);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"settingsManager.getPrope\u2026rSettings.KEEP_INVENTORY)");
        if (bl.booleanValue()) {
            playerDeathEvent.setKeepInventory(true);
        }
        Boolean bl2 = this.settingsManager.getProperty(WarSettings.CLEAR_DROPS);
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"settingsManager.getPrope\u2026(WarSettings.CLEAR_DROPS)");
        if (bl2.booleanValue()) {
            playerDeathEvent.getDrops().clear();
        }
        Boolean bl3 = this.settingsManager.getProperty(WarSettings.KEEP_EXP);
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"settingsManager.getProperty(WarSettings.KEEP_EXP)");
        if (bl3.booleanValue()) {
            playerDeathEvent.setKeepLevel(true);
        }
        String string = this.challengeHandler.getAllPlayersAlive(guildChallenge2).get(playerDeathEvent.getEntity().getUniqueId());
        if (string == null) {
            return;
        }
        String string2 = string;
        Map<UUID, String> map = this.playerDeath;
        UUID uUID = playerDeathEvent.getEntity().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"entity.uniqueId");
        map.put(uUID, string2);
        this.challengeHandler.announceDeath(guildChallenge2, this.guilds, playerDeathEvent.getEntity(), playerDeathEvent.getEntity(), ChallengeHandler.Cause.PLAYER_KILLED_UNKNOWN);
        this.challengeHandler.handleFinish(this.guilds, this.settingsManager, playerDeathEvent.getEntity(), guildChallenge2);
    }

    @EventHandler
    public final void onRespawn(@NotNull PlayerRespawnEvent playerRespawnEvent) {
        Intrinsics.checkNotNullParameter((Object)playerRespawnEvent, (String)"<this>");
        Map<UUID, String> map = this.playerDeath;
        UUID uUID = playerRespawnEvent.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        if (!map.containsKey(uUID)) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.guilds, () -> ArenaListener.onRespawn$lambda$0(this, playerRespawnEvent), 1L);
    }

    @EventHandler
    public final void onCommand(@NotNull PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        Intrinsics.checkNotNullParameter((Object)playerCommandPreprocessEvent, (String)"<this>");
        if (!this.settingsManager.getProperty(WarSettings.DISABLE_COMMANDS).booleanValue()) {
            return;
        }
        GuildChallenge guildChallenge = this.challengeHandler.getChallenge(playerCommandPreprocessEvent.getPlayer());
        if (guildChallenge == null) {
            return;
        }
        GuildChallenge guildChallenge2 = guildChallenge;
        if (playerCommandPreprocessEvent.getPlayer().hasPermission("guilds.command.admin")) {
            return;
        }
        playerCommandPreprocessEvent.setCancelled(true);
        this.guilds.getCommandManager().getCommandIssuer(playerCommandPreprocessEvent.getPlayer()).sendInfo(Messages.WAR__COMMANDS_BLOCKED, new String[0]);
    }

    private static final void onRespawn$lambda$0(ArenaListener arenaListener, PlayerRespawnEvent playerRespawnEvent) {
        Intrinsics.checkNotNullParameter((Object)arenaListener, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)playerRespawnEvent, (String)"$this_onRespawn");
        Location location = ACFBukkitUtil.stringToLocation(arenaListener.playerDeath.get(playerRespawnEvent.getPlayer().getUniqueId()));
        playerRespawnEvent.getPlayer().teleport(location);
        arenaListener.playerDeath.remove(playerRespawnEvent.getPlayer().getUniqueId());
    }
}

