/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.listeners;

import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.configuration.sections.ClaimSettings;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guild.GuildRolePerm;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.ClaimUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.codemc.worldguardwrapper.WorldGuardWrapper;
import org.codemc.worldguardwrapper.selection.ICuboidSelection;

public class ClaimSignListener
implements Listener {
    private final Guilds guilds;
    private final SettingsManager settingsManager;
    private final GuildHandler guildHandler;
    private final WorldGuardWrapper wrapper = WorldGuardWrapper.getInstance();

    public ClaimSignListener(Guilds guilds, SettingsManager settingsManager, GuildHandler guildHandler) {
        this.guilds = guilds;
        this.settingsManager = settingsManager;
        this.guildHandler = guildHandler;
    }

    @EventHandler
    public void onSignChange(SignChangeEvent signChangeEvent) {
        Player player = signChangeEvent.getPlayer();
        if (!signChangeEvent.getLine(0).equalsIgnoreCase(this.settingsManager.getProperty(ClaimSettings.CLAIM_SIGN_TEXT))) {
            return;
        }
        if (!player.hasPermission("guilds.claimsigns.place") && !player.hasPermission("worldguard.region.redefine.*")) {
            this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.CLAIM__SIGN_NO_PERMISSION, new String[0]);
            signChangeEvent.setCancelled(true);
            return;
        }
        if (!this.settingsManager.getProperty(ClaimSettings.CLAIM_SIGNS).booleanValue()) {
            this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.CLAIM__SIGN_NOT_ENABLED, new String[0]);
            signChangeEvent.setCancelled(true);
            return;
        }
        if (signChangeEvent.getLine(1).isEmpty() || signChangeEvent.getLine(2).isEmpty()) {
            this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.CLAIM__SIGN_INVALID_FORMAT, new String[0]);
            signChangeEvent.setCancelled(true);
            return;
        }
        if (!ClaimUtils.checkAlreadyExist(this.wrapper, player, signChangeEvent.getLine(1))) {
            this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.CLAIM__SIGN_INVALID_REGION, new String[0]);
            signChangeEvent.setCancelled(true);
            return;
        }
        this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.CLAIM__SIGN_PLACED, "{region}", signChangeEvent.getLine(1), "{price}", signChangeEvent.getLine(2));
    }

    @EventHandler
    public void onSignInteract(PlayerInteractEvent playerInteractEvent) {
        if (!playerInteractEvent.hasBlock()) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        BlockState blockState = block.getState();
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        Player player = playerInteractEvent.getPlayer();
        if (!sign.getLine(0).equalsIgnoreCase("[Guild Claim]")) {
            return;
        }
        if (!this.settingsManager.getProperty(ClaimSettings.CLAIM_SIGNS).booleanValue()) {
            this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.CLAIM__SIGN_NOT_ENABLED, new String[0]);
            playerInteractEvent.setCancelled(true);
            return;
        }
        Guild guild = this.guildHandler.getGuild((OfflinePlayer)player);
        if (guild == null) {
            this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.ERROR__NO_GUILD, new String[0]);
            return;
        }
        if (!guild.memberHasPermission(player, GuildRolePerm.CLAIM_LAND)) {
            this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.ERROR__ROLE_NO_PERMISSION, new String[0]);
            return;
        }
        if (ClaimUtils.checkAlreadyExist(this.wrapper, guild)) {
            this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.CLAIM__ALREADY_EXISTS, new String[0]);
            return;
        }
        if (guild.getBalance() < Double.valueOf(sign.getLine(2))) {
            this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.CLAIM__SIGN_NOT_ENOUGH, new String[0]);
            return;
        }
        ClaimUtils.getClaim(this.wrapper, player, sign.getLine(1)).ifPresent(iWrappedRegion -> {
            ICuboidSelection iCuboidSelection = ClaimUtils.getSelection(this.wrapper, player, iWrappedRegion.getId());
            this.wrapper.removeRegion(player.getWorld(), iWrappedRegion.getId());
            ClaimUtils.createClaim(this.wrapper, guild, iCuboidSelection);
        });
        ClaimUtils.getGuildClaim(this.wrapper, player, guild).ifPresent(iWrappedRegion -> {
            ClaimUtils.addOwner(iWrappedRegion, guild);
            ClaimUtils.addMembers(iWrappedRegion, guild);
            ClaimUtils.setEnterMessage(this.wrapper, iWrappedRegion, this.settingsManager, guild);
            ClaimUtils.setExitMessage(this.wrapper, iWrappedRegion, this.settingsManager, guild);
        });
        player.getWorld().getBlockAt(block.getLocation()).breakNaturally();
        guild.setBalance(guild.getBalance() - Double.valueOf(sign.getLine(2)));
        this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.CLAIM__SIGN_BUY_SUCCESS, new String[0]);
    }
}

