/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.listeners;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.configuration.sections.GuildSettings;
import me.glaremasters.guilds.configuration.sections.PluginSettings;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guild.GuildHome;
import me.glaremasters.guilds.guild.GuildMember;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.kyori.adventure.text.Component;
import me.glaremasters.guilds.libs.kyori.adventure.text.TextComponent;
import me.glaremasters.guilds.libs.kyori.adventure.text.event.ClickEvent;
import me.glaremasters.guilds.libs.kyori.adventure.text.event.HoverEvent;
import me.glaremasters.guilds.libs.kyori.adventure.text.format.StyleSetter;
import me.glaremasters.guilds.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.StringUtils;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0007J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u0013H\u0007J\f\u0010\u0015\u001a\u00020\u0012*\u00020\u0013H\u0007J\f\u0010\u0016\u001a\u00020\u0012*\u00020\u0013H\u0007J\f\u0010\u0017\u001a\u00020\u0012*\u00020\u0018H\u0007J\f\u0010\u0019\u001a\u00020\u0012*\u00020\u0013H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lme/glaremasters/guilds/listeners/PlayerListener;", "Lorg/bukkit/event/Listener;", "guilds", "Lme/glaremasters/guilds/Guilds;", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "permission", "Lnet/milkbowl/vault/permission/Permission;", "(Lme/glaremasters/guilds/Guilds;Lch/jalu/configme/SettingsManager;Lme/glaremasters/guilds/guild/GuildHandler;Lnet/milkbowl/vault/permission/Permission;)V", "informed", "", "Ljava/util/UUID;", "serializer", "Lme/glaremasters/guilds/libs/kyori/adventure/text/serializer/legacy/LegacyComponentSerializer;", "Lorg/jetbrains/annotations/NotNull;", "onJoin", "", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onLastLoginUpdate", "onMOTD", "onPermCheck", "onRespawn", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "onUpdateSkullCheck", "Guilds"})
public final class PlayerListener
implements Listener {
    @NotNull
    private final Guilds guilds;
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final GuildHandler guildHandler;
    @NotNull
    private final Permission permission;
    @NotNull
    private final Set<UUID> informed;
    @NotNull
    private final LegacyComponentSerializer serializer;

    public PlayerListener(@NotNull Guilds guilds, @NotNull SettingsManager settingsManager, @NotNull GuildHandler guildHandler, @NotNull Permission permission) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"guilds");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"guildHandler");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        this.guilds = guilds;
        this.settingsManager = settingsManager;
        this.guildHandler = guildHandler;
        this.permission = permission;
        this.informed = new LinkedHashSet();
        LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.legacySection();
        Intrinsics.checkNotNullExpressionValue((Object)legacyComponentSerializer, (String)"legacySection()");
        this.serializer = legacyComponentSerializer;
    }

    @EventHandler
    public final void onJoin(@NotNull PlayerJoinEvent playerJoinEvent) {
        Intrinsics.checkNotNullParameter((Object)playerJoinEvent, (String)"<this>");
        if (!this.settingsManager.getProperty(PluginSettings.ANNOUNCEMENTS_IN_GAME).booleanValue()) {
            return;
        }
        if (!playerJoinEvent.getPlayer().isOp()) {
            return;
        }
        if (this.informed.contains(playerJoinEvent.getPlayer().getUniqueId())) {
            return;
        }
        Guilds.newChain().delay(5, TimeUnit.SECONDS).async(() -> PlayerListener.onJoin$lambda$0(this, playerJoinEvent)).execute();
        UUID uUID = playerJoinEvent.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        this.informed.add(uUID);
    }

    @EventHandler
    public final void onMOTD(@NotNull PlayerJoinEvent playerJoinEvent) {
        Intrinsics.checkNotNullParameter((Object)playerJoinEvent, (String)"<this>");
        Guild guild = this.guildHandler.getGuild((OfflinePlayer)playerJoinEvent.getPlayer());
        if (guild == null) {
            return;
        }
        Guild guild2 = guild;
        String string = guild2.getMotd();
        if (string == null) {
            return;
        }
        String string2 = string;
        if (!this.settingsManager.getProperty(GuildSettings.MOTD_ON_LOGIN).booleanValue()) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.guilds, () -> PlayerListener.onMOTD$lambda$1(this, playerJoinEvent, string2), 100L);
    }

    @EventHandler
    public final void onLastLoginUpdate(@NotNull PlayerJoinEvent playerJoinEvent) {
        Intrinsics.checkNotNullParameter((Object)playerJoinEvent, (String)"<this>");
        Guild guild = this.guildHandler.getGuild((OfflinePlayer)playerJoinEvent.getPlayer());
        if (guild == null) {
            return;
        }
        Guild guild2 = guild;
        GuildMember guildMember = guild2.getMember(playerJoinEvent.getPlayer().getUniqueId());
        if (guildMember.getJoinDate() == 0L) {
            guildMember.setJoinDate(System.currentTimeMillis());
        }
        guildMember.setLastLogin(System.currentTimeMillis());
    }

    @EventHandler
    public final void onUpdateSkullCheck(@NotNull PlayerJoinEvent playerJoinEvent) {
        Intrinsics.checkNotNullParameter((Object)playerJoinEvent, (String)"<this>");
        Guild guild = this.guildHandler.getGuild((OfflinePlayer)playerJoinEvent.getPlayer());
        if (guild == null) {
            return;
        }
        Guild guild2 = guild;
        if (!guild2.isMaster((OfflinePlayer)playerJoinEvent.getPlayer())) {
            return;
        }
        guild2.updateGuildSkull(playerJoinEvent.getPlayer(), this.settingsManager);
    }

    @EventHandler
    public final void onPermCheck(@NotNull PlayerJoinEvent playerJoinEvent) {
        Intrinsics.checkNotNullParameter((Object)playerJoinEvent, (String)"<this>");
        this.guildHandler.addGuildPerms(this.permission, (OfflinePlayer)playerJoinEvent.getPlayer());
        this.guildHandler.addRolePerm(this.permission, (OfflinePlayer)playerJoinEvent.getPlayer());
    }

    @EventHandler
    public final void onRespawn(@NotNull PlayerRespawnEvent playerRespawnEvent) {
        Intrinsics.checkNotNullParameter((Object)playerRespawnEvent, (String)"<this>");
        Guild guild = this.guildHandler.getGuild((OfflinePlayer)playerRespawnEvent.getPlayer());
        if (guild == null) {
            return;
        }
        Guild guild2 = guild;
        GuildHome guildHome = guild2.getHome();
        if (guildHome == null) {
            return;
        }
        GuildHome guildHome2 = guildHome;
        if (!this.settingsManager.getProperty(GuildSettings.RESPAWN_AT_HOME).booleanValue()) {
            return;
        }
        playerRespawnEvent.setRespawnLocation(guildHome2.getAsLocation());
    }

    private static final void onJoin$lambda$0(PlayerListener playerListener, PlayerJoinEvent playerJoinEvent) {
        Intrinsics.checkNotNullParameter((Object)playerListener, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)playerJoinEvent, (String)"$this_onJoin");
        try {
            HoverEvent<Component> hoverEvent = HoverEvent.showText(playerListener.serializer.deserialize(StringUtils.getAnnouncements(playerListener.guilds)));
            Intrinsics.checkNotNullExpressionValue(hoverEvent, (String)"showText(serializer.dese\u2026etAnnouncements(guilds)))");
            HoverEvent<Component> hoverEvent2 = hoverEvent;
            ClickEvent clickEvent = ClickEvent.openUrl(String.valueOf(playerListener.guilds.getDescription().getWebsite()));
            Intrinsics.checkNotNullExpressionValue((Object)clickEvent, (String)"openUrl(guilds.description.website.toString())");
            ClickEvent clickEvent2 = clickEvent;
            StyleSetter styleSetter = ((TextComponent)playerListener.serializer.deserialize("\u00a7f[\u00a7aGuilds\u00a7f]\u00a7r Announcements (Hover over me for more information)").clickEvent(clickEvent2)).hoverEvent(hoverEvent2);
            Intrinsics.checkNotNullExpressionValue((Object)styleSetter, (String)"serializer.deserialize(\"\u2026(click).hoverEvent(hover)");
            TextComponent textComponent = (TextComponent)styleSetter;
            playerListener.guilds.getAdventure().sender((CommandSender)playerJoinEvent.getPlayer()).sendMessage(textComponent);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static final void onMOTD$lambda$1(PlayerListener playerListener, PlayerJoinEvent playerJoinEvent, String string) {
        Intrinsics.checkNotNullParameter((Object)playerListener, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)playerJoinEvent, (String)"$this_onMOTD");
        Intrinsics.checkNotNullParameter((Object)string, (String)"$motd");
        String[] stringArray = new String[]{"{motd}", string};
        playerListener.guilds.getCommandManager().getCommandIssuer(playerJoinEvent.getPlayer()).sendInfo(Messages.MOTD__MOTD, stringArray);
    }
}

