/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.tasks;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.api.events.challenges.GuildWarStartEvent;
import me.glaremasters.guilds.challenges.ChallengeHandler;
import me.glaremasters.guilds.configuration.sections.WarSettings;
import me.glaremasters.guilds.guild.GuildChallenge;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.WarUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitRunnable;

public class GuildWarReadyTask
extends BukkitRunnable {
    private final Guilds guilds;
    private int timeLeft;
    private final List<UUID> players;
    private final String message;
    private final GuildChallenge challenge;
    private final ChallengeHandler challengeHandler;
    private final String notifyType;

    public GuildWarReadyTask(Guilds guilds, int n, List<UUID> list2, String string, GuildChallenge guildChallenge, ChallengeHandler challengeHandler) {
        this.guilds = guilds;
        this.timeLeft = n;
        this.players = list2;
        this.message = string;
        this.challenge = guildChallenge;
        this.challengeHandler = challengeHandler;
        this.notifyType = guilds.getSettingsHandler().getMainConf().getProperty(WarSettings.NOTIFY_TYPE);
    }

    public void run() {
        this.players.forEach(uUID -> {
            Player player = Bukkit.getPlayer((UUID)uUID);
            if (player != null) {
                WarUtils.notify(this.notifyType, this.message.replace("{amount}", String.valueOf(this.timeLeft)), this.guilds.getAdventure().player(player));
            }
        });
        --this.timeLeft;
        if (this.timeLeft == 0) {
            Object object;
            this.challenge.setJoinble(false);
            if (!this.challengeHandler.checkEnoughOnline(this.challenge.getChallenger(), this.challenge.getDefender(), this.challenge.getMinPlayersPerSide())) {
                this.challenge.getChallenger().sendMessage(this.guilds.getCommandManager(), Messages.WAR__NOT_ENOUGH_ON, new String[0]);
                this.challenge.getDefender().sendMessage(this.guilds.getCommandManager(), Messages.WAR__NOT_ENOUGH_ON, new String[0]);
                this.challenge.getArena().setInUse(false);
                this.challengeHandler.removeChallenge(this.challenge);
                this.cancel();
                return;
            }
            this.challengeHandler.prepareFinalList(this.challenge.getChallengePlayers(), this.challenge, "challenger");
            this.challengeHandler.prepareFinalList(this.challenge.getDefendPlayers(), this.challenge, "defender");
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.challenge.getAliveDefenders().size() > this.challenge.getAliveChallengers().size()) {
                do {
                    object = (UUID)((Map.Entry)Iterables.getLast(this.challenge.getAliveDefenders().entrySet())).getKey();
                    arrayList.add(Bukkit.getPlayer((UUID)object).getName());
                    this.challenge.getAliveDefenders().remove(object);
                } while (this.challenge.getAliveDefenders().size() != this.challenge.getAliveChallengers().size());
            } else if (this.challenge.getAliveChallengers().size() > this.challenge.getAliveDefenders().size()) {
                do {
                    object = (UUID)((Map.Entry)Iterables.getLast(this.challenge.getAliveChallengers().entrySet())).getKey();
                    arrayList.add(Bukkit.getPlayer((UUID)object).getName());
                    this.challenge.getAliveChallengers().remove(object);
                } while (this.challenge.getAliveChallengers().size() != this.challenge.getAliveDefenders().size());
            }
            if (arrayList.size() > 0) {
                object = Joiner.on((String)", ").join(arrayList);
                this.challenge.getChallenger().sendMessage(this.guilds.getCommandManager(), Messages.WAR__REMOVED_FOR_SIZE, new String[]{"{players}", object});
                this.challenge.getDefender().sendMessage(this.guilds.getCommandManager(), Messages.WAR__REMOVED_FOR_SIZE, new String[]{"{players}", object});
            }
            arrayList.clear();
            this.challengeHandler.sendToArena(this.challenge.getAliveChallengers(), this.challenge.getArena().getChallengerLoc());
            this.challengeHandler.sendToArena(this.challenge.getAliveDefenders(), this.challenge.getArena().getDefenderLoc());
            this.challenge.setStarted(true);
            this.challenge.getDefender().setLastDefended(System.currentTimeMillis());
            Bukkit.getPluginManager().callEvent((Event)new GuildWarStartEvent(this.challenge.getChallenger(), this.challenge.getDefender()));
            this.cancel();
        }
    }
}

